/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.InstructionWithChildren;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.xpath.DynamicError;
import net.sf.saxon.xpath.XPathException;

public abstract class ElementCreator
extends InstructionWithChildren {
    protected AttributeSet[] useAttributeSets;
    protected SchemaType schemaType;
    protected int validation;
    protected boolean inheritNamespaces = true;

    public ItemType getItemType() {
        return NodeKindTest.ELEMENT;
    }

    public int getCardinality() {
        return 512;
    }

    public void setValidationMode(int n) {
        this.validation = n;
    }

    public int getValidationMode() {
        return this.validation;
    }

    protected abstract int getNameCode(XPathContext var1) throws XPathException;

    protected abstract void outputNamespaceNodes(XPathContext var1, Receiver var2) throws XPathException;

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        try {
            int n = this.getNameCode(xPathContext);
            if (n == -1) {
                this.skipElement(xPathContext);
                return null;
            }
            Controller controller = xPathContext.getController();
            XPathContext xPathContext2 = xPathContext;
            SequenceReceiver sequenceReceiver = xPathContext.getReceiver();
            Receiver receiver = controller.getConfiguration().getElementValidator(sequenceReceiver, n, this.locationId, this.schemaType, this.validation, controller.getNamePool());
            if (receiver != sequenceReceiver) {
                xPathContext2 = xPathContext.newMinorContext();
                xPathContext2.setOrigin(this);
                sequenceReceiver = new TreeReceiver(receiver);
                sequenceReceiver.setConfiguration(controller.getConfiguration());
                xPathContext2.setReceiver(sequenceReceiver);
            }
            int n2 = this.inheritNamespaces ? 0 : 128;
            sequenceReceiver.startElement(n, -1, this.locationId, n2);
            this.outputNamespaceNodes(xPathContext2, sequenceReceiver);
            if (this.useAttributeSets != null) {
                AttributeSet.expand(this.useAttributeSets, xPathContext2);
            }
            this.processChildren(xPathContext2);
            sequenceReceiver.endElement();
            return null;
        }
        catch (DynamicError dynamicError) {
            if (dynamicError.getXPathContext() == null) {
                dynamicError.setXPathContext(xPathContext);
            }
            if (dynamicError.getLocator() == null) {
                dynamicError.setLocator(this);
            }
            throw dynamicError;
        }
    }

    private void skipElement(XPathContext xPathContext) throws XPathException {
        xPathContext.getReceiver().startElement(-1, -1, this.locationId, 0);
        this.processChildren(xPathContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        try {
            Controller controller = xPathContext.getController();
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            xPathContextMinor.setOrigin(this);
            SequenceOutputter sequenceOutputter = new SequenceOutputter();
            sequenceOutputter.setConfiguration(controller.getConfiguration());
            int n = this.getNameCode(xPathContextMinor);
            Receiver receiver = controller.getConfiguration().getElementValidator(sequenceOutputter, n, this.locationId, this.schemaType, this.validation, controller.getNamePool());
            SequenceReceiver sequenceReceiver = sequenceOutputter;
            if (receiver == sequenceOutputter) {
                xPathContextMinor.setTemporaryReceiver(sequenceOutputter);
            } else {
                TreeReceiver treeReceiver = new TreeReceiver(receiver);
                treeReceiver.setConfiguration(controller.getConfiguration());
                treeReceiver.setDocumentLocator(this.getExecutable().getLocationMap());
                xPathContextMinor.setReceiver(treeReceiver);
                sequenceReceiver = treeReceiver;
            }
            sequenceReceiver.open();
            sequenceReceiver.startElement(n, -1, this.locationId, 0);
            this.outputNamespaceNodes(xPathContextMinor, sequenceReceiver);
            this.processChildren(xPathContextMinor);
            sequenceReceiver.endElement();
            sequenceReceiver.close();
            return sequenceOutputter.getFirstItem();
        }
        catch (XPathException xPathException) {
            if (xPathException instanceof ValidationException) {
                ((ValidationException)xPathException).setSourceLocator(this);
                ((ValidationException)xPathException).setSystemId(this.getSystemId());
            }
            if (xPathException.getLocator() == null) {
                xPathException.setLocator(this);
            }
            if (xPathException instanceof DynamicError) {
                ((DynamicError)xPathException).setXPathContext(xPathContext);
            }
            throw xPathException;
        }
    }
}

