/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StrippedDocument;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.xpath.XPathException;

public class StrippedNode
implements NodeInfo,
VirtualNode {
    protected NodeInfo node;
    protected StrippedNode parent;
    protected StrippedDocument docWrapper;

    protected StrippedNode() {
    }

    protected StrippedNode(NodeInfo nodeInfo, StrippedNode strippedNode) {
        this.node = nodeInfo;
        this.parent = strippedNode;
    }

    protected StrippedNode makeWrapper(NodeInfo nodeInfo, StrippedDocument strippedDocument, StrippedNode strippedNode) {
        StrippedNode strippedNode2 = new StrippedNode(nodeInfo, strippedNode);
        strippedNode2.docWrapper = strippedDocument;
        return strippedNode2;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    public int getNodeKind() {
        return this.node.getNodeKind();
    }

    public SequenceIterator getTypedValue(Configuration configuration) throws XPathException {
        return this.node.getTypedValue(configuration);
    }

    public int getTypeAnnotation() {
        return this.node.getTypeAnnotation();
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (nodeInfo instanceof StrippedNode) {
            return this.node.isSameNodeInfo(((StrippedNode)nodeInfo).node);
        }
        return this.node.isSameNodeInfo(nodeInfo);
    }

    public String getSystemId() {
        return this.node.getSystemId();
    }

    public void setSystemId(String string) {
        this.node.setSystemId(string);
    }

    public String getBaseURI() {
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof StrippedNode) {
            return this.node.compareOrder(((StrippedNode)nodeInfo).node);
        }
        return this.node.compareOrder(nodeInfo);
    }

    public String getStringValue() {
        switch (this.getNodeKind()) {
            case 1: 
            case 9: {
                NodeInfo nodeInfo;
                AxisIterator axisIterator = this.iterateAxis((byte)4, NodeKindTest.makeNodeKindTest(3));
                StringBuffer stringBuffer = new StringBuffer(1024);
                while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                    stringBuffer.append(nodeInfo.getStringValue());
                }
                return stringBuffer.toString();
            }
        }
        return this.node.getStringValue();
    }

    public int getNameCode() {
        return this.node.getNameCode();
    }

    public int getFingerprint() {
        return this.node.getFingerprint();
    }

    public String getLocalPart() {
        return this.node.getLocalPart();
    }

    public String getURI() {
        return this.node.getURI();
    }

    public String getDisplayName() {
        return this.node.getDisplayName();
    }

    public NodeInfo getParent() {
        NodeInfo nodeInfo;
        if (this.parent == null && (nodeInfo = this.node.getParent()) != null) {
            this.parent = this.makeWrapper(nodeInfo, this.docWrapper, null);
        }
        return this.parent;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 2: 
            case 8: {
                return new WrappingIterator(this.node.iterateAxis(by), this);
            }
            case 3: {
                return new StrippingIterator(this.node.iterateAxis(by), this);
            }
            case 7: 
            case 11: {
                StrippedNode strippedNode = (StrippedNode)this.getParent();
                if (strippedNode == null) {
                    return EmptyIterator.getInstance();
                }
                return new StrippingIterator(this.node.iterateAxis(by), strippedNode);
            }
        }
        return new StrippingIterator(this.node.iterateAxis(by), null);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        if (nodeTest.allowsTextNodes()) {
            return new Navigator.AxisFilter(this.iterateAxis(by), nodeTest);
        }
        return new WrappingIterator(this.node.iterateAxis(by, nodeTest), this);
    }

    public String getAttributeValue(int n) {
        return this.node.getAttributeValue(n);
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        return this.node.hasChildNodes();
    }

    public String generateId() {
        return this.node.generateId();
    }

    public int getDocumentNumber() {
        return this.docWrapper.getDocumentNumber();
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        Stripper stripper = this.docWrapper.getStripper().getAnother();
        stripper.setUnderlyingReceiver(receiver);
        this.node.copy(stripper, n, bl, n2);
    }

    public void outputNamespaceNodes(Receiver receiver, boolean bl) throws XPathException {
        this.node.outputNamespaceNodes(receiver, bl);
    }

    private final class StrippingIterator
    implements AxisIterator {
        AxisIterator base;
        StrippedNode parent;
        NodeInfo currentVirtualNode;
        int position;

        public StrippingIterator(AxisIterator axisIterator, StrippedNode strippedNode2) {
            this.base = axisIterator;
            this.parent = strippedNode2;
            this.position = 0;
        }

        public Item next() {
            NodeInfo nodeInfo;
            NodeInfo nodeInfo2;
            do {
                if ((nodeInfo = (NodeInfo)this.base.next()) == null) {
                    return null;
                }
                if (nodeInfo.getNodeKind() != 3 || !Navigator.isWhite(nodeInfo.getStringValue())) break;
                NodeInfo nodeInfo3 = nodeInfo2 = this.parent == null ? nodeInfo.getParent() : this.parent.node;
            } while (StrippedNode.this.docWrapper.getStripper().isSpacePreserving(nodeInfo2) != 1);
            this.currentVirtualNode = StrippedNode.this.makeWrapper(nodeInfo, StrippedNode.this.docWrapper, this.parent);
            ++this.position;
            return this.currentVirtualNode;
        }

        public Item current() {
            return this.currentVirtualNode;
        }

        public int position() {
            return this.position;
        }

        public SequenceIterator getAnother() {
            return new StrippingIterator((AxisIterator)this.base.getAnother(), this.parent);
        }
    }

    private final class WrappingIterator
    implements AxisIterator,
    AtomizableIterator {
        AxisIterator base;
        StrippedNode parent;
        Item current;
        boolean atomizing = false;

        public WrappingIterator(AxisIterator axisIterator, StrippedNode strippedNode2) {
            this.base = axisIterator;
            this.parent = strippedNode2;
        }

        public Item next() {
            Item item = this.base.next();
            this.current = item instanceof NodeInfo && !this.atomizing ? StrippedNode.this.makeWrapper((NodeInfo)item, StrippedNode.this.docWrapper, this.parent) : item;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() {
            return new WrappingIterator(this.base, this.parent);
        }

        public void setIsAtomizing(boolean bl) {
            this.atomizing = true;
            if (this.base instanceof AtomizableIterator) {
                ((AtomizableIterator)((Object)this.base)).setIsAtomizing(bl);
            }
        }
    }
}

