/*
 * Decompiled with CFR 0.152.
 */
package com.mybada.docbook.docbook_helper.transform;

import com.mybada.docbook.docbook_helper.gui.FileSelectorPanel;
import com.mybada.docbook.docbook_helper.main.TestFrame;
import com.mybada.docbook.docbook_helper.model.TaskOutput;
import java.io.File;
import java.io.FileWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TransformThread
extends Thread {
    private TaskOutput taskOutput;
    private FileSelectorPanel fileSelector;
    private TestFrame mainFrame;

    public TransformThread(TestFrame mainFrame, TaskOutput taskOutput, FileSelectorPanel fileSelector) {
        this.taskOutput = taskOutput;
        this.mainFrame = mainFrame;
        this.fileSelector = fileSelector;
    }

    public void run() {
        this.taskOutput.println("----------------------------------");
        this.taskOutput.println("\ubcc0\ud658\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4...");
        String xmlFileName = "";
        String xslFileName = "";
        String outputFileName = "";
        xmlFileName = this.fileSelector.getSrcXmlFileName();
        xslFileName = this.fileSelector.getSrcXslFileName();
        outputFileName = this.fileSelector.getOutputFileName();
        if (xslFileName.length() == 0 || xmlFileName.length() == 0 || !xslFileName.endsWith(".xsl") || !xmlFileName.endsWith(".xml")) {
            this.taskOutput.println("\ubcc0\ud658\uc774 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4: XML \ubc0f XSL \ud30c\uc77c\uc744 \uc81c\ub300\ub85c \uc120\ud0dd\ud574 \uc8fc\uc138\uc694.");
            this.mainFrame.taskDone();
            return;
        }
        if (outputFileName.length() == 0) {
            outputFileName = this.getDefaultOutputFile(xmlFileName);
        }
        this.taskOutput.println("\ubcc0\ud658 \uc911\uc785\ub2c8\ub2e4, \uc7a0\uc2dc\ub9cc \uae30\ub2e4\ub824 \uc8fc\uc2ed\uc2dc\uc624...");
        try {
            FileWriter outFile = new FileWriter(new File(outputFileName));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(new File(xslFileName)));
            transformer.transform(new StreamSource(new File(xmlFileName)), new StreamResult(outFile));
        }
        catch (Exception e) {
            this.taskOutput.println("\ubcc0\ud658\uc774 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4: " + e);
            this.mainFrame.taskDone();
            return;
        }
        this.taskOutput.println("\ubcc0\ud658\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        this.mainFrame.taskDone();
    }

    private String getDefaultOutputFile(String xmlFileName) {
        String headPart = xmlFileName.substring(0, xmlFileName.lastIndexOf(".xml"));
        return headPart + ".html";
    }
}

