/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

class BooleanExpression
extends BinaryExpression {
    public BooleanExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public int computeCardinality() {
        return 512;
    }

    public Expression analyze(StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.analyze(staticContext, itemType);
        if (expression instanceof BooleanExpression) {
            ((BooleanExpression)expression).operand0 = ExpressionTool.unsorted(this.operand0, false);
            ((BooleanExpression)expression).operand1 = ExpressionTool.unsorted(this.operand1, false);
        }
        return expression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        switch (this.operator) {
            case 10: {
                return this.operand0.effectiveBooleanValue(xPathContext) && this.operand1.effectiveBooleanValue(xPathContext);
            }
            case 9: {
                return this.operand0.effectiveBooleanValue(xPathContext) || this.operand1.effectiveBooleanValue(xPathContext);
            }
        }
        throw new UnsupportedOperationException("Unknown operator in boolean expression");
    }

    public ItemType getItemType() {
        return Type.BOOLEAN_TYPE;
    }
}

