/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;

public class DynamicQueryContext {
    private Item contextItem;
    private HashMap parameters;
    private Configuration config;
    private URIResolver uriResolver;
    private ErrorListener errorListener;

    public DynamicQueryContext(Configuration configuration) {
        this.config = configuration;
        this.uriResolver = configuration.getURIResolver();
        this.errorListener = configuration.getErrorListener();
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(2);
        }
    }

    public void setContextNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        this.contextItem = nodeInfo;
    }

    public void setContextItem(Item item) {
        if (item == null) {
            throw new NullPointerException("Context item cannot be null");
        }
        this.contextItem = item;
    }

    public NodeInfo getContextNode() {
        return this.contextItem instanceof NodeInfo ? (NodeInfo)this.contextItem : null;
    }

    public Item getContextItem() {
        return this.contextItem;
    }

    public void setParameter(String string, Object object) {
        if (this.parameters == null) {
            this.parameters = new HashMap(10);
        }
        this.parameters.put(string, object);
    }

    public void clearParameters() {
        this.parameters = null;
    }

    public Object getParameter(String string) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(string);
    }

    protected HashMap getParameters() {
        return this.parameters;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.uriResolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }
}

