<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
     xmlns:isoi18n="java:com.isogen.saxoni18n.Saxoni18nService"
     xmlns:td="http://www.innodata-isogen.com/vocabularies/samples/trival_document_type"
>

<xsl:import href="generate_index.xsl"/>  
  
<!--============================================
    NOTE: This style sheet will only work with
    Saxon 6.5.
    ============================================-->
    
<xsl:output 
    encoding="UTF-8"
    method="html"
    omit-xml-declaration="yes"
/>    
    
<xsl:param name="docLang"><!-- national language of the document -->
  <xsl:choose>
    <xsl:when test="string(/td:doc/@xml:lang) != ''">
      <xsl:value-of select="string(/td:doc/@xml:lang)"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="'not_specified'"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:param>   
 
<xsl:template match="/">
  <xsl:message> + Document language=<xsl:value-of select="$docLang"/></xsl:message>
  <html>
    <head>
      <title>
        <xsl:apply-templates select="/td:doc/td:docmetadata/td:doctitle" mode="doctitle"/>
      </title>
    </head>
    <body>
      <div>
        <xsl:apply-templates select="/td:doc/td:docmetadata"/>
        <p align="right"><i>Document Language: <xsl:value-of select="$docLang"/></i></p>
        <xsl:call-template name="generate_toc"/>
        <xsl:apply-templates/>
        <xsl:call-template name="generate_index"/>
      </div>      
    </body>
  </html>
</xsl:template>

<xsl:template match="td:docmetadata">
  <div>
  <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="td:doctitle">
  <h1><xsl:apply-templates/></h1>
</xsl:template>

<xsl:template match="td:date_last_updated">
  <p><b>Last Updated: </b> <xsl:apply-templates/></p>
</xsl:template>

<xsl:template match="td:copyright">
  <p>
    <xsl:text>Copyright (&#xa9;) </xsl:text>
    <xsl:value-of select="@firstdate"/>
    <xsl:if test="string(@lastdate) != ''">
      <xsl:text>, </xsl:text>
      <xsl:value-of select="@lastdate"/>
    </xsl:if>
    <xsl:text>, </xsl:text>
    <xsl:apply-templates/>
  </p>
</xsl:template>

<xsl:template match="td:doc">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="/*/td:body">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="td:docmetadata" mode="doctitle">
  <xsl:apply-templates select="td:doctitle" mode="doctitle"/>
</xsl:template>

<xsl:template match="td:doctitle" mode="doctitle">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="td:sect">
  <div>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="td:intro">
  <div>
    <xsl:apply-templates/>
  </div>
</xsl:template>

<xsl:template match="td:body/td:sect/td:title">
  <hr/>
  <h2><a name="{generate-id(..)}"
    /><xsl:apply-templates
  /></h2>
</xsl:template>  

<xsl:template match="td:body/td:sect/td:sect/td:title">
  <h3><a name="{generate-id(..)}"
    /><xsl:apply-templates
  /></h3>
</xsl:template>  

<xsl:template match="td:body/td:sect/td:sect/td:sect/td:title">
  <h4><a name="{generate-id(..)}"
    /><xsl:apply-templates
  /></h4>
</xsl:template>  

<xsl:template match="td:p">
  <p>
    <xsl:apply-templates/>
  </p>
</xsl:template> 

<xsl:template match="td:index_entry">

  <!-- Create targets for entries in the generated index -->
  <a name="{generate-id(.)}"/>
</xsl:template>

<!-- Places where index entries should not make targets: -->
<xsl:template match="td:index_entry" mode="doctitle"/>
<xsl:template match="td:index_entry" mode="toc"/>

<xsl:template name="generate_toc">
  <div>
    <hr/>
    <h2>
      <xsl:value-of select="isoi18n:getGeneratedTextForKeyBefore('#contents', $docLang)"/>
    </h2>
    <ul>
      <xsl:apply-templates select="/td:doc/td:body/td:sect" mode="toc"/>
      <li>
        <a href="#botb-index"><xsl:value-of select="isoi18n:getGeneratedTextForKeyBefore('#index', $docLang)"/></a>
      </li>
    </ul>
  </div>
</xsl:template>

<xsl:template match="td:sect" mode="toc">
  <xsl:apply-templates select="td:title" mode="toc"/>
  <ul>
    <xsl:apply-templates select="td:sect" mode="toc"/>
  </ul>
</xsl:template>

<xsl:template match="td:sect/td:title" mode="toc">
  <li>
    <a href="{concat('#', generate-id(..))}"
      ><xsl:apply-templates
    /></a>
  </li>
</xsl:template>

<xsl:template match="td:*">
  <xsl:copy>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

</xsl:stylesheet>