<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [

<!ENTITY primary   'normalize-space(concat(td:primary/@sortas, td:primary[not(@sortas)]))'>

<!ENTITY group-key "isoi18n:getIndexGroupKey(/td:doc/@xml:lang, 
                                             &primary;)"
>

<!ENTITY secondary 'normalize-space(concat(td:secondary/@sortas, td:secondary[not(@sortas)]))'> 
<!ENTITY tertiary  'normalize-space(concat(td:tertiary/@sortas, td:tertiary[not(@sortas)]))'>

<!ENTITY sep '" "'>
]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:func="http://exslt.org/functions"
                xmlns:isoi18n="java:com.isogen.saxoni18n.Saxoni18nService"
                xmlns:td="http://www.innodata-isogen.com/vocabularies/samples/trival_document_type"
                exclude-result-prefixes="isoi18n func"
                extension-element-prefixes="isoi18n"								
                version="1.0">


<!-- ==================================================================== -->
<!-- Derived from Jeni Tennison's work in the HTML case
  
     This code is further based on the DocBook 4.x index processing code.
  -->

<xsl:key name="letter"
  match="td:index_entry[td:primary[string(self::*) != '']]"
         use="&group-key;"/>

<xsl:key name="primary"
  match="td:index_entry[td:primary[string(self::*) != '']]"
         use="&primary;"/>

<xsl:key name="secondary"
  match="td:index_entry[td:primary[string(self::*) != '']]"
         use="concat(&primary;, &sep;, &secondary;)"/>

<xsl:key name="tertiary"
  match="td:index_entry[td:primary[string(self::*) != '']]"
         use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;)"/>

<xsl:key name="see-also"
  match="td:index_entry[td:seealso and td:primary[string(self::*) != '']]"
         use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, seealso)"/>

<xsl:key name="see"
  match="td:index_entry[td:see and td:primary[string(self::*) != '']]"
         use="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, see)"/>


<xsl:template name="generate_index">
  <div>
    <hr/>
    <h2>
      <a name="botb-index"/>
      <xsl:value-of select="isoi18n:getGeneratedTextForKeyBefore('#index', $docLang)"/>
    </h2>
    
    <xsl:variable name="sort.language" select="$docLang"/>
    <xsl:message> + Processing index, sort language="<xsl:value-of select="$sort.language"/>", ...</xsl:message>
    <xsl:variable name="terms"
      select="//td:index_entry[td:primary[string(self::*) != ''] and
                                      count(.|key('letter',
                                                  isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;)))[1]) = 1]"/>
                                      
    <xsl:variable name="alphabetical"
                  select="$terms[not(starts-with('#NUMERIC',
                                              isoi18n:getIndexGroupKey($sort.language, &primary;)))]"/>
  
    <xsl:variable name="others" select="$terms[starts-with('#NUMERIC',
                                               isoi18n:getIndexGroupKey($sort.language, &primary;))]"/>
  
    <div>
      <xsl:if test="$others">
        <div>
          <xsl:call-template name="indexdiv.title">
            <xsl:with-param name="titlecontent" select="isoi18n:getGeneratedTextForKeyBefore('#NUMERIC', $docLang)"/>
          </xsl:call-template>
    
          <dl>
            <xsl:apply-templates select="$others[1]"
                                 mode="index-symbol-div">
              <xsl:with-param name="sort.language" select="$sort.language"/>
              <xsl:sort lang="{$sort.language}" 
                        select="isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;))"/>
            </xsl:apply-templates>
          </dl>
        </div>
      </xsl:if>
  
      <xsl:apply-templates select="$alphabetical[count(.|key('letter',
                                   isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;)))[1]) = 1]"
                           mode="index-div">
        <xsl:with-param name="sort.language" select="$sort.language"/>
        <xsl:sort lang="{$sort.language}" select="isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;))"/>
      </xsl:apply-templates>
    </div>
  </div>
  <xsl:message> + Index processing done.</xsl:message>
</xsl:template>

<xsl:template match="td:index_entry" mode="index-div">
  <xsl:param name="sort.language"/>

  <div>
    <xsl:call-template name="indexdiv.title">
      <xsl:with-param name="titlecontent">
        <xsl:value-of select="isoi18n:getIndexGroupLabel($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;))"/>
      </xsl:with-param>
    </xsl:call-template>
    <dl>
      <xsl:apply-templates select="key('letter', isoi18n:getIndexGroupKey($sort.language, &primary;))
                                   [count(.|key('primary', &primary;)[1])=1]"
                           mode="index-primary">
        <xsl:with-param name="sort.language" select="$sort.language"/>
  			<xsl:sort lang="{$sort.language}" select="&primary;"/>          
      </xsl:apply-templates>
    </dl>
  </div>
</xsl:template>

<xsl:template match="td:index_entry" mode="index-symbol-div">
  <xsl:param name="sort.language"/>

  <xsl:variable name="key"
                select="isoi18n:getIndexGroupSortKey($sort.language, isoi18n:getIndexGroupKey($sort.language, &primary;))"/>

  <xsl:apply-templates select="key('letter', $key)[count(.|key('primary', &primary;)[1]) = 1]"
                       mode="index-primary">
    <xsl:with-param name="sort.language" select="$sort.language"/>
    <xsl:sort lang="{$sort.language}" select="&primary;"/>
  </xsl:apply-templates>
</xsl:template>

<xsl:template match="td:index_entry" mode="index-primary">
  <xsl:param name="sort.language"/>
  
  <xsl:variable name="key" select="&primary;"/>
  <xsl:variable name="refs" select="key('primary', $key)"/>
  <dt>
    <xsl:apply-templates select="td:primary"/>

    <xsl:variable name="page-number-citations">
      <xsl:for-each select="$refs[not(td:see) and not(td:seealso)
                            and not(td:secondary)]">
        <xsl:apply-templates select="." mode="reference"/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:if test="not(td:secondary)">
      <xsl:copy-of select="$page-number-citations"/>
    </xsl:if>
  </dt>
  <dd>
    <xsl:if test="$refs[not(td:secondary)]/*[self::td:see]">
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see', concat(&primary;, &sep;, &sep;, &sep;, td:see))[1])]"
                           mode="index-see">
         <xsl:with-param name="sort.language" select="$sort.language"/>
        <xsl:sort lang="{$sort.language}" select="td:see"/>
      </xsl:apply-templates>
    </xsl:if>

    <xsl:if test="$refs/td:secondary or $refs[not(td:secondary)]/*[self::td:seealso]">
      <dl>
        <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see-also', concat(&primary;, &sep;, &sep;, &sep;, td:seealso))[1])]"
                             mode="index-seealso">
          <xsl:with-param name="sort.language" select="$sort.language"/>
          <xsl:sort lang="{$sort.language}" select="td:seealso"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="$refs[td:secondary and count(.|key('secondary', concat($key, &sep;, &secondary;))[1]) = 1]"
                             mode="index-secondary">
          <xsl:with-param name="sort.language" select="$sort.language"/>
          <xsl:sort lang="{$sort.language}" select="&secondary;"/>
        </xsl:apply-templates>
      </dl>
    </xsl:if>    
  </dd>
</xsl:template>


<xsl:template match="td:index_entry" mode="index-see">

   <span>
     <xsl:text> (</xsl:text>
     <xsl:value-of select="isoi18n:getGeneratedTextForKeyBefore('#see', $docLang)"/>
     <xsl:text> </xsl:text>
     <xsl:apply-templates select="td:see"/>
     <xsl:text>)</xsl:text>
   </span>
</xsl:template>

<xsl:template match="td:index_entry" mode="index-seealso">

   <dd>
     <xsl:text>(</xsl:text>
     <xsl:value-of select="isoi18n:getGeneratedTextForKeyBefore('#seealso', $docLang)"/>
     <xsl:text> </xsl:text>
     <xsl:apply-templates select="td:seealso"/>
     <xsl:text>)</xsl:text>
   </dd>
</xsl:template>

<xsl:template match="td:index_entry" mode="index-secondary">
  <xsl:param name="sort.language"/>

  <xsl:variable name="key" select="concat(&primary;, &sep;, &secondary;)"/>
  <xsl:variable name="refs" select="key('secondary', $key)"/>
  <dt>
    <xsl:apply-templates select="td:secondary"/>

    <xsl:variable name="page-number-citations">
      <xsl:for-each select="$refs[not(td:see) and not(td:seealso)
                                      and not(td:tertiary)]">
        <xsl:apply-templates select="." mode="reference"/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:if test="not(td:tertiary)">
      <xsl:copy-of select="$page-number-citations"/>
    </xsl:if>
  </dt>
  <dd>
    <xsl:if test="$refs[not(td:tertiary)]/*[self::td:see]">
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see', concat(&primary;, &sep;, &secondary;, &sep;, &sep;, td:see))[1])]"
                           mode="index-see">
        <xsl:with-param name="sort.language" select="$sort.language"/>
        <xsl:sort lang="{$sort.language}" select="td:see"/>
      </xsl:apply-templates>
    </xsl:if>

    <xsl:if test="$refs/td:tertiary or $refs[not(td:tertiary)]/*[self::td:seealso]">
      <dl>
        <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see-also', concat(&primary;, &sep;, &secondary;, &sep;, &sep;, td:seealso))[1])]"
                             mode="index-seealso">
          <xsl:with-param name="sort.language" select="$sort.language"/>
          <xsl:sort lang="{$sort.language}" select="td:seealso"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="$refs[td:tertiary and count(.|key('tertiary', concat($key, &sep;, &tertiary;))[1]) = 1]" 
                             mode="index-tertiary">
          <xsl:with-param name="sort.language" select="$sort.language"/>
          <xsl:sort lang="{$sort.language}" select="&tertiary;"/>
        </xsl:apply-templates>
      </dl>
    </xsl:if>
  </dd>
</xsl:template>

<xsl:template name="indexdiv.title">
  <xsl:param name="titlecontent"/>
  <h3><xsl:copy-of select="$titlecontent"/></h3>
</xsl:template>  

<xsl:template match="td:index_entry" mode="index-tertiary">
  <xsl:param name="sort.language"/>
  
  <xsl:variable name="key" select="concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;)"/>
  <xsl:variable name="refs" select="key('tertiary', $key)"/>
  <dt>
    <xsl:apply-templates select="td:tertiary"/>

    <xsl:variable name="page-number-citations">
      <xsl:for-each select="$refs[not(td:see) and not(td:seealso)]">
        <xsl:apply-templates select="." mode="reference"/>
      </xsl:for-each>
    </xsl:variable>

    <xsl:copy-of select="$page-number-citations"/>
  </dt>
  <dd>
    <xsl:if test="$refs/td:see">
      <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see', concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, td:see))[1])]"
                           mode="index-see">
        <xsl:sort lang="{$sort.language}" select="td:see"/>
      </xsl:apply-templates>
    </xsl:if>

    <xsl:if test="$refs/td:seealso">
      <br/>
        <xsl:apply-templates select="$refs[generate-id() = generate-id(key('see-also', concat(&primary;, &sep;, &secondary;, &sep;, &tertiary;, &sep;, td:seealso))[1])]"
                             mode="index-seealso">
          <xsl:sort lang="{$sort.language}" select="td:seealso"/>
        </xsl:apply-templates>
    </xsl:if>
  </dd>
</xsl:template>

<xsl:template match="td:index_entry" mode="reference">
  <xsl:text> </xsl:text><a href="{concat('#', generate-id(.))}">
    <xsl:text>[</xsl:text>
    <xsl:text>*</xsl:text>
    <xsl:text>]</xsl:text>
  </a>
</xsl:template>  
<!--======================================
     Debugging routines
     ======================================-->
     
<xsl:template name="report_index_terms">
  <xsl:param name="item_list"/>
  <xsl:param name="sort.language"/>
  
  <xsl:message>Index Term Report. Sort language="<xsl:value-of select="$sort.language"/>"
  </xsl:message>
  <xsl:apply-templates select="$item_list" mode="report_index_terms">
    <xsl:with-param name="sort.language" select="$sort.language"/>
    <xsl:sort lang="$sort.language" select="&primary;"/>
  </xsl:apply-templates>
</xsl:template>     

<xsl:template match="td:index_entry" mode="report_index_terms">
  <xsl:param name="sort.language"/>
<xsl:message>*** sort.language=<xsl:value-of select="$sort.language"/></xsl:message>
  <xsl:variable name="primary" select="isoi18n:escapeUnicodeString(string(td:primary))"/>
  <xsl:message> + <xsl:value-of select="isoi18n:escapeUnicodeString($primary)"/></xsl:message>
  <xsl:message>   group key: <xsl:value-of select="isoi18n:escapeUnicodeString(isoi18n:getIndexGroupKey($sort.language, &primary;))"/></xsl:message>
  <xsl:for-each select="td:secondary">
    <xsl:sort lang="$sort.language" select="&secondary;"/>
    <xsl:message>   Secondary: <xsl:value-of select="isoi18n:escapeUnicodeString(string(.))"/></xsl:message>
  </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
