import com.mybada.docbook.docbook_helper.gui.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class TestFrame extends JFrame implements ActionListener {
	private FileSelectorPanel fileSelector;
	private JTabbedPane tabs = new JTabbedPane();
	private JTextArea ta = new JTextArea();
	private JTextPane tp = new JTextPane();
	private DisplayPanel displayPanel = new DisplayPanel();

	public TestFrame() {
		setTitle("DocBook Helper GUI v0.1");
		setSize(300, 500);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		fileSelector = new FileSelectorPanel();
		getContentPane().add(fileSelector, BorderLayout.NORTH);

		
		//  г 
		JPanel mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		
		// ... ư 
		JPanel buttonPanel = new JPanel();
		JButton transformButton = new JButton("Transform");
		buttonPanel.add(transformButton);
		JButton toFileButton = new JButton("To File");
		buttonPanel.add(toFileButton);
		transformButton.addActionListener(this);
		toFileButton.addActionListener(this);
		mainPanel.add(buttonPanel, BorderLayout.NORTH);
		
		// ...   
		mainPanel.add(displayPanel, BorderLayout.CENTER);

		getContentPane().add(mainPanel, BorderLayout.CENTER);
	}

	public void actionPerformed(ActionEvent e) {
		//printFiles();

		String cmd = e.getActionCommand();
		if (cmd.equals("Transform")) {
			displayPanel.setSource(getTransformedText2());
		} 

	}

	private String getTransformedText() {
		File srcXmlFile = fileSelector.getSrcXmlFile();
		String s1, s2 = new String();
	
		try {
			BufferedReader in = new BufferedReader(new FileReader(srcXmlFile));
			while (	(s1 = in.readLine()) != null ) {
				s2 += s1 + "\n";
			}
			in.close();
		}
		catch (IOException ie) {
			s2 = "";
		}

		return s2;
	}

	private String getTransformedText2() {
		try {
			StringWriter writer = new StringWriter();

			// 1. Instantiate a TransformerFactory.
			javax.xml.transform.TransformerFactory tFactory = 
				javax.xml.transform.TransformerFactory.newInstance();

			// 2. Use the TransformerFactory to process the stylesheet Source and
			//    generate a Transformer.
			javax.xml.transform.Transformer transformer = tFactory.newTransformer
				(new javax.xml.transform.stream.StreamSource(fileSelector.getSrcXslFile()));

			// 3. Use the Transformer to transform an XML Source and send the
			//    output to a Result object.
			transformer.transform(
				new javax.xml.transform.stream.StreamSource(fileSelector.getSrcXmlFile()), 
				new javax.xml.transform.stream.StreamResult(writer)
			);

			return writer.toString();
		}
		catch (Exception e) {
		}

		return "";

	}


	private void printFiles() {
		File srcXmlFile = fileSelector.getSrcXmlFile();
		File srcXslFile = fileSelector.getSrcXslFile();
		File outputFile = fileSelector.getOutputFile();

		System.out.println(srcXmlFile);
		System.out.println(srcXslFile);
		System.out.println(outputFile);

	}

	public static void main(String[] args) {
		JFrame frame = new TestFrame();
		frame.pack();
		frame.show();
	}
}
