package com.mybada.docbook.docbook_helper.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class DisplayPanel extends JPanel {
	private JTabbedPane tabs = new JTabbedPane();
	private JEditorPane sourcePane = new JEditorPane();
	private JEditorPane browserPane = new JEditorPane();

	private String source = new String();

	public DisplayPanel() {
		setLayout(new BorderLayout());
		
		JScrollPane sourceScroll = new JScrollPane(sourcePane);
		JScrollPane browserScroll = new JScrollPane(browserPane);
		tabs.addTab("Source", sourceScroll);
		browserPane.setContentType("text/html");
		tabs.addTab("Browser", browserScroll);

		add(tabs, BorderLayout.CENTER);

		tabs.addChangeListener(new MyChangeListener());
	}

	class MyChangeListener implements ChangeListener {
		public void stateChanged(ChangeEvent e) {
			if (tabs.getSelectedIndex() == 1) {
				if (source.length() != 0) {
					browserPane.setText(source);
					browserPane.setContentType("text/html");
				}
			}
		}
	}

	public void setSource(String src) {
		source = src;
		sourcePane.setText(src);
	}

}