#include <cv.h>
#include <highgui.h>
#include <cxcore.h>

#include <iostream.h>

void main()
{
	IplImage *pImage_a = cvLoadImage("a.jpg");
	IplImage *pImage_b = cvLoadImage("b.jpg");

	IplImage *pGrayImage_a = cvCreateImage(cvGetSize(pImage_a),8,1);
	IplImage *pGrayImage_b = cvCreateImage(cvGetSize(pImage_a),8,1);

	cvCvtColor(pImage_a,pGrayImage_a,CV_RGB2GRAY);
	cvCvtColor(pImage_b,pGrayImage_b,CV_RGB2GRAY);

	IplImage *pSub_Image = cvCreateImage(cvGetSize(pImage_a),8,1);

	cvNamedWindow("a");
	cvShowImage("a",pImage_a);
	
	cvNamedWindow("b");
	cvShowImage("b",pImage_b);

	cvSub(pGrayImage_a,pGrayImage_b,pSub_Image);

	double Max;
	double Min;
	CvPoint Min_pt,Max_pt;
	cvMinMaxLoc(pSub_Image,&Min,&Max,&Min_pt,&Max_pt);

	cout<<"Max : "<<Max<<endl<<"Point : "<<Max_pt.x<<" : "<<Max_pt.y<<endl;

	cvEllipse(pSub_Image,Max_pt,cvSize(10,10),0,0,360,CV_RGB(100,100,100),1);

	cvNamedWindow("sub");
	cvShowImage("sub",pSub_Image);

	cvWaitKey(0);

	cvDestroyAllWindows();
	cvReleaseImage(&pImage_a);
	cvReleaseImage(&pImage_b);

	cvReleaseImage(&pGrayImage_a);
	cvReleaseImage(&pGrayImage_b);

	cvReleaseImage(&pSub_Image);
}