<?php // -*-php-*-
rcs_id('$Id: AllPages.php,v 1.2 2005/03/17 16:58:59 gryu Exp $');

require_once('lib/TextSearchQuery.php');

function case_insensitive_cmp ($a, $b) {
    if ($a == $b ) return 0;
    return (strtolower($a) < strtolower($b) ) ? -1 : 1;
}
		


/**
 */
class WikiPlugin_AllPages
extends WikiPlugin
{
	var $name = 'AllPages';
	
	function getDefaultArguments() {
		// FIXME: how to exclude multiple pages?
		return array();
	}

	function run($dbi, $argstr, $request) {
		global $encoding;
		
		$page_tbl = $dbi->_backend->_table_names['page_tbl'];
		$nonempty_tbl = $dbi->_backend->_table_names['nonempty_tbl'];
		$sql = "SELECT pagename 
FROM $page_tbl as p, $nonempty_tbl as n
WHERE p.id = n.id
ORDER BY pagename ASC";
		if(!$f_res = mysql_query($sql) )
		{
				echo "$f_res \n";
				echo $sql;
				die("Error getting data<br>$sql");
		}
		
		while($row = mysql_fetch_assoc($f_res))
		{
			$pagenames[] = $row['pagename'];
		}
		
		usort($pagenames, "case_insensitive_cmp");

		$html = '<a name="#top"></a>{:index:}';
		if ($encoding == 'euc-kr')
		{
			// ٶ...
			$korean_index = array("\xB0\xA1","\xB3\xAA","\xB4\xD9","\xB6\xF3","\xB8\xB6","\xB9\xD9","\xBB\xE7",
				"\xBE\xC6","\xC0\xDA","\xC2\xF7","\xC4\xAB","\xC5\xB8","\xC6\xC4","\xC7\xCF", "\xFF\xFF");
			$lettersize = 2;
		}
		else //utf-8
		{
			$korean_index = array( "\xEA\xB0\x80","\xEB\x82\x98","\xEB\x8B\xA4","\xEB\x9D\xBC","\xEB\xA7\x88","\xEB\xB0\x94","\xEC\x82\xAC",
"\xEC\x95\x84","\xEC\x9E\x90","\xEC\xB0\xA8","\xEC\xB9\xB4","\xED\x83\x80","\xED\x8C\x8C","\xED\x95\x98", "\xFF\xFF\xFF");
			$lettersize = 3;
		}

		$idx = '';
		$previdx = '';
		$indexnum = 0;
		$indexhtml = '';
		foreach( $pagenames as $pagename)
		{
			$idx = strtoupper( substr($pagename, 0, 1) );
			$i = 0;
			if (ord($idx) > 127) 
			{
				$idx = substr($pagename, 0, $lettersize);

				for ($i = 0; $i < count($korean_index) ; $i++)
				{
					if ( ($idx >= $korean_index[$i])  and  ($idx < $korean_index[$i+1]) ) 
					{
						$idx = $korean_index[$i];
						break;
					}
				}
				if ($i > count($korean_index) ) $idx = _T('etc');
			}
			if (ord($idx) < ord('A') ) $idx = _T('number');
			
			if ($idx <> $previdx)
			{
				$indexnum += 1;
				$html .=  '<a name="'.$indexnum.'">&nbsp;</a><a href="#pagetop"><h2>' . $idx . '</h2></a></center>';
				$indexhtml .= '<a href="#'. $indexnum .'">'. $idx .'</a> | ';
			}
			$previdx = $idx;
			$html .=  LinkWikiWord($pagename) . '<br/>';
		}

		$html =  str_replace('{:index:}', $indexhtml, $html);
		return $html;
	}

	function _quote($str) {
		return "'" . str_replace("'", "''", $str) . "'";
	}
};
		
// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End:   
?>
