<?
import("php.db.Data");


class DBData extends Data {

	protected $table;
	protected $types = array();
	
	public function __construct($connector = null, $table = null) {
		parent::__construct($connector);

		$this->setTable($table);
	}

	// ̺ ̸  
	public function setTable($table) {
		$this->table = $table;
	}

	public function getTable() {
		return $this->table;
	}

	public function getTypeList() { 
		return $this->types;
	}

	public function setTypeList($arr) { 
		$this->types = array_change_key_case($arr, CASE_LOWER);
	}

	// ʵ  ˻Ѵ. 
	public function __call($field, $args) { 
		$isOne	= true;

		$values = $args[0];
		$type	= $args[1];
		$column = ($args[2]) ? $args[2] : ' * ';

		// ˻ϴ  迭  
		if (is_array($values)) { 

			foreach ($values as $key => $v) { 
				$values[$key] = $this->getConnector()->escape($v);
			}

			if ($args[1] == 'string') { 
				$values = "'".implode("','", $values)."'";
			} else { 
				$values = implode(",", $values);
			}

			// ε ű  
			$isOne = false;
		}

		// ˻ڿ ϼ 
		$temp = $values;

		// sql ϼ 
		$sql = "select {$column} from {$this->table} where {$field} in ( {$temp} )";

//		echo $sql;

		$this->setData($this->getConnector()->getData($sql));

		if ($isOne) { 
			$this->next();
		}
	}

/*
	// num Ÿ ȸ 
	public function num($num) { 
		$isOne = true;

		if (is_array($num)) { 
			$num = implode(",", $num);
			$isOne = false;
		}

		$sql = "select * from {$this->table} where num in ( {$num} )";

		$this->setData($this->getConnector()->getData($sql));
		
		if ($isOne) { 
			$this->next();
		}

	}
*/
	// ˻ 
	public function select($where = '', $hasNext = false, $field_list = array())
	{
		$connector = $this->getConnector();

		$sql = new Sql($connector->program, "select");
		$sql->setFrom($this->table);

		foreach ($field_list as $field) { 
			$sql->add($field);
		}

		$str = $sql->toString(). " ". (trim($where) == '' ? '' : ' where '. $where );

//		echo $str;

		$data = $connector->getData($str);

		$this->setData($data);

		if ($hasNext) $this->next();
	}

	// ¡ ˻  
	public function selectPage($where = '', $page = 1 , $pagesize = 10)
	{
		$connector = $this->getConnector();

		$sql = new Sql($connector->program, "select");
		$sql->setFrom($this->table);

		if ($connector->is('mssql')) { 
			$sql->setTop($page * $pagesize);
		}

		$str = $sql->toString(). " ". (trim($where) == '' ? '' : ' where '. $where );

//		echo $str;

		$data = $connector->getPageData($str, $page, $pagesize);

		$this->setData($data);
	}

	public function selectCount($where = '', $pagesize = 10, $blocksize = 10)
	{
		$connector = $this->getConnector();

		$sql = new Sql($connector->program, "select");
		$sql->setFrom($this->table);
		$sql->add('count(*) as cnt', '', false);

		$str = $sql->toString(). " ". (trim($where) == '' ? '' : ' where '. $where );

		return $connector->getPageCountQuery($str, $pagesize, $blocksize);
	}



	//  
	public function delete() {
		$connector = $this->getConnector();

		$tempSql = $connector->deleteSql($this);

		return $connector->query($tempSql->toString());
	}

	//  
	public function update($omit = array()) {
		$connector = $this->getConnector();

		$tempSql = $connector->updateSql($this, $omit);

//		echo $tempSql;

		return $connector->query($tempSql->toString());
	}

	// Է  
	public function insert($omit = array()) {
		$connector = $this->getConnector();

		$tempSql = $connector->insertSql($this, $omit);

		return $connector->query($tempSql->toString()) or die("insert : ".$connector->error());
	}

	//  insert
	public function insertAll($omit = array()) {
		$this->saveIndex();

		while($this->next()) 
			$this->insert($omit);

		$this->returnIndex();
	}

	//  delete
	public function deleteAll() {
		$this->saveIndex();

		while($this->next()) 
			$this->delete();

		$this->returnIndex();
	}

	//  update
	public function updateAll($omit = array()) {
		$this->saveIndex();

		while($this->next()) 
			$this->update($omit);

		$this->returnIndex();
	}

	// ܺ Ÿ   
	public function getSubData($table, $field, $field2, $isOne = false) { 
		$value = $this->get($field2);
		$sql = "select * from {$table} where $field = '{$value}'";

		return $this->getConnector()->getData($sql, $isOne);
	}
}
?>