<?php
import("php.db.DBClient");
import("php.db.MssqlConfig");

class Mssql extends DBClient {

	private $bindList = array();
	private $defineList = array();

	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);

		parent::__construct($program, $host, $port, $id, $pass, $db, $schema, $version);
	}


	protected function _connect() { 
		return mssql_connect($this->getAttribute('host'), $this->getAttribute('id'), $this->getAttribute('pass'));
	}

	protected function _selectDb() { 
		mssql_select_db($this->getAttribute('db'), $this->con);
	}

	public function close() {
		mssql_close($this->con);
	}

	public function escape($str) { 
		return str_replace("'", "''", $str);
	}

	public function error() {
		return "";
	}

	public function execute() {
		$this->exec = mssql_execute($this->stmt);
		return $this->exec;
	}

	public function query($sql) {
		$this->result = mssql_query($sql, $this->con);
		return $this->result;
	}	

	public function remote()
	{
		return $this->query("SET ANSI_NULLS ON ; SET ANSI_WARNINGS ON;");
	}

	public function free($result) { 
		return mssql_free_result($result);
	}

	public function getFieldCount($result) {
		return mssql_num_fields($result);
	}

	public function getFieldName($result, $i) {
		return mssql_field_name($result, $i);
	}

	public function getFieldType($result, $i) {
		return mssql_field_type($result, $i);
	}

	// Ÿ  
	public function fetch($result) {
		return mssql_fetch_assoc($result);
	}

	public function result($result, $row, $field) 
	{
		return mssql_result($result, $row, $field);
	}

	// ʱȭ 
	public function freeStatement($result) {
		// 
		return mssql_free_statement($result);
	}

	public function init($sp_name) {
		$this->stmt = mssql_init($sp_name);
		return $this->stmt;
	}

	//  ڵ  
	public function nextResult($result) {
		return mssql_next_result($result);
	}

	public function bind($name, &$value, $type, $isOutput = false, $isNull = false , $maxLength = -1){
		return mssql_bind($this->stmt, $name, $value, $this->getTypeName($type), $isOutput, $isNull, $maxLength);
	}

	public function seek($count) { 
		return mssql_data_seek($this->getResult(), $count);
	}

	private function getTypeName($type)
	{
		$type = strtoupper($type);

		switch ($type) {
			case 'SMALLDATETIME' :
			case 'DATETIME' :
			case 'VARCHAR': 
			case 'NVARCHAR':
			case 'BINARY':
			case 'IMAGE':
			case 'VARBINARY':
			case 'SQL_VARIANT':
				return SQLVARCHAR;
			case 'INT': 
			case 'BIGINT':
			case 'SMALLINT':
			case 'TIMESTAMP':
				return SQLINT4;
			case 'TEXT' : 
			case 'NTEXT':
				return SQLTEXT;
			case 'BIT' : 
				return SQLBIT;
			case 'FLOAT' :
			case 'DECIMAL' :
			case 'MONEY' : 
			case 'REAL':
				return SQLFLT8;
			default: 
				return $type;
		}
	}

	public function createPageData($result, $page, $pagesize, $baseClass = "DBData") {
		// ⺻ Data Ŭ ϰ 
		// Data Ŭ  ٸ Data Ŭ ϸ ȴ. 
		$data = new $baseClass();
		$data->setBaseClass($baseClass);
		$data->setDatabase($this);

		//ʵ Ʈ 
		$data->setFields($this->getFieldList($result));
		
		if (!$result) 
			return $data;

		while($d = $this->fetch($result)) 
			$data->add($d);

		return $data;
	}

	public function getPageData($query, $page = 1, $count = 10, $baseClass = 'DBData') {
		$total = $page * $count;

		$query = "select top {$total} * from ($query) TEMP_SELECT ";

		// ..
		$this->query($query);

		// ġ ̵ 
		$this->seek(($page-1)*$count);

		$data = $this->createData($this->getResult(), $baseClass);

		return $data;

	}

	/* Ÿ Ÿ ̽  */

}

?>