<?php
import("php.db.DBClient");
import("php.db.PostgresConfig");

class Postgres extends DBClient {

	private $tempStmt;

	private $cursor = array();
	private $bindList = array();
	private $defineList = array();

	public function __construct($host = '', $port = '', $id = '', $pass = '', $db = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);
		parent::__construct($program, $host, $port, $id, $pass, $db, $schema, $version);
	}

	public function _connect() {

		$str = sprintf("host=%s port=%s dbname=%s user=%s password=%s", 
				$this->host,
				$this->port,
				$this->db,
				$this->id,
				$this->pass
		);

		return pg_connect($str);
	}

	public function _selectDb() { 
		return false;
	}

	public function close() {
		pg_close($this->con);
	}

	public function free($result) { 
		return pg_free_result ($result);
	}

	public function error() {
		return pg_last_error($this->con);
	}

	public function affectedRows() { 
		return pg_affected_rows($this->getResult());
	}

	public function escape($str) { 
		return pg_escape_string($str);
	}

	public function execute($name, $data = array()) {
		$this->result = pg_execute($this->con, $name, $data);
		return $this->result;
	}

	public function prepare($name, $query) {
		$this->result = pg_prepare($this->con, $name, $query);
		return $this->result;
	}

	// Ϲ   
	public function query($query) {
		$this->result = pg_query($this->con, $query);
		return $this->result;
	}

	public function query_params($query, $param) { 
		$this->result = pg_query_params($this->con, $query, $param);
		return $this->result;
	}

	public function getResult() { 
		return $this->result;
	}

	public function getFieldCount($result) {
		return pg_num_fields ($result);
	}

	public function getFieldName($result, $i) {
		return pg_field_name($result, $i);
	}

	public function getFieldType($result, $i) {
		return pg_field_type($result, $i);
	}

	// ٽ  ؾ.
	public function commit() {
		return true;
	}

	// ٽ  ؾ.
	public function rollback() {
		return true;
	}

	public function fetch($result) {
		return pg_fetch_assoc($result);
	}


	// ε  Ÿ 
	function getBindData($query, $param, $isOne = false, $baseClass = "DBData") {
		$this->query_params($query, $param);
	
		$data = $this->createData($this->getResult(), $baseClass);

		//   ¥ true
		// true ̸ next ٷ  · Ѿ´. 
		if ($isOne) 
			$data->next();

		return $data;
	}

	public function getPageData($query, $page, $count = 10,$baseClass = 'DBData') {

		//  ϱ 
		$start = ($page-1)*$count+1;

		$query .= " limit $1 offset $2";

		return $this->getBindData($query, array($count, $start), false, $baseClass);
	}

}

?>