<?php
import("php.db.DBClient");
//import("php.db.SqliteConfig");

class Sqlite extends DBClient {

	public function __construct($db = '', $host = '', $port = '', $id = '', $pass = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);
		parent::__construct($program, $host, $port, $id, $pass, $db, $schema, $version);
	}

	public function error() {
		return sqlite_error_string(sqlite_last_error($this->con)) ;
	}

	protected function _connect() { 
		return sqlite_open($this->getAttribute('host').$this->getAttribute('db'));
	}

	protected function _selectDb() { 
		return true;
	}

	public function close()
	{
		if ($this->con) { 
			sqlite_close($this->con);
		}
	}

	public function affectedRows() { 
		return sqlite_changes($this->con);
	}

	public function escape($item) { 
		return sqlite_escape_string ($item);
	}

	public function free($result) {
		return true;
	}

	public function query($sql) {
		$this->result = sqlite_query($this->con, $sql);
		return $this->result;
	}

	public function getFieldCount($result) {
		return sqlite_num_fields($result);
	}

	public function getFieldName($result, $i) {
		return sqlite_field_name($result, $i);
	}

	public function getFieldType($result, $i) {
		return "varchar";
	}

	// Ÿ  
	public function fetch($result) {
		return sqlite_fetch_array($result);
	}
	
	function getPageData($query, $page, $count = 10,$baseClass = 'DBData')
	{
		//  ϱ 
		$start = ($page-1)*$count;

		$query .= " limit $start, $count";

		return $this->getData($query, false, $baseClass);
	}

	function seek($rownum ) { 
		return sqlite_seek ( $this->getResult(), $rownum );
	}


	/* Ÿ Ÿ ̽  */
}

?>