<?

import("php.db.DBData");

class CodeData extends DBData 
{
	public function __construct($db = null, $table = null) { 
		parent::__construct($db, $table);
	}

	// ڵ Ʈ 
	public function getCodeList() {
		$value = $this->code_list;

		$temp = explode(PHP_EOL, trim($value));

		$temp2 = explode(":", $value);
		$temp2 = array_map("trim", $temp2);

		if ($temp2[0] == 'dbcode') { 
			return CodeData::getDbCodeSelect($this->getConnector(), $value, 'db_list');
		} 

		return CodeData::getCodeSelect($this->name, $temp);
	}

	// CodeData ü  
	public static function getCodeData($db, $name) {
		$name = strtoupper($name);

		$data = new CodeData($db, 'codes');
		$data->select(" name = '{$name}'", true);

		return $data;
	}

	// 迭 select ٲ
	public static function getCodeSelect($name, $arr, $hasKey = false) { 
		$select = T_('select', true);
		$select->setAttribute(
			array('id' => $name)
		);


		if ($hasKey == false) { 
			foreach ($arr as $code) { 

				$temp2 = explode(":", $code);
				$temp2 = array_map('trim', $temp2);

				$option = T_('option', true)->add($code);
				$option->addAttribute('value', $temp2[0]);			
				$select->add($option);
			}
		} else { 
			foreach ($arr as $key => $value) { 

				$code = " {$key} : {$value}" ;

				$option = T_('option', true)->add($code);
				$option->addAttribute('value', $key);			
				$select->add($option);
			}
		}

		return $select;
	}

	// db ڵ select ϱ 
	public static function getDbCodeSelect($db, $str, $name = '') { 
		$temp2 = explode(":", $str);
		$temp2 = array_map('trim', $temp2);
		$select = $str;
		
		if ($temp2[0] == 'dbcode') { 
			$name	= $temp2[1];
			$table	= $temp2[2];
			$key	= $temp2[3];
			$value	= $temp2[4];

			$data = new ServiceData($db, 'services');
			$data->select(" name = '{$name}'", true);

			$db2	= $data->createConnector();
			$data2	= $db2->getData("select distinct {$key} as key_type,{$value} as value_type from {$table} order by key_type ");
			$temp2	= $data2->getColumnList('value_type', 'key_type');

			$select = CodeData::getCodeSelect('db_list', $temp2, true);
		} 

		return $select;
	}

	// ü ڵ select
	public static function getCode($db, $str, $name = '') { 
		$code_list = trim($str);
		$temp = explode(":", $code_list);
		$select = "";

		$temp = array_map('trim', $temp);
		$temp[1] = strtolower($temp[1]);

		if ($temp[0] == 'mcode') { 
			$code_data = CodeData::getCodeData($db, $temp[1]);
			$temp_code_list = $code_data->code_list;

			$temp2 = explode(":", $temp_code_list);
			
			// db ڵ ̸ Ÿ̽ ڵ带  ´. 
			if ($temp2[0] == 'dbcode') { 
				$select = CodeData::getDbCodeSelect($db, $temp_code_list, 'db_list');
			} else { 
				$select = $code_data->getCodeList();
			}
		} else { 
			if ($code_list !== "") { 
				$temp2 = explode(",", $code_list);
				if (count($temp2) > 0) { 
					$select = CodeData::getCodeSelect($name, $temp2);
				}
			}
		} 

		return $select;
	}

	// ڵ ڿ ȯ 
	public static function getCodeString($db, $str) {
		$code_list = trim($str);
		$temp = array_map('trim', explode(":", $code_list));

		if ($temp[0] == 'mcode') { 
			$code_data = CodeData::getCodeData($db, $temp[1]);
			$temp_code_list = explode(PHP_EOL, $code_data->code_list);
		} else { 
			$temp_code_list = array_map('trim', explode(",", $code_list));
		}

		if ($code_list !== "") { 
			$table = T_('table', true);
			$table->addAttribute('border', "1");

			$tr = T_('tr',true)->add(T_('th', true)->add('ڵ'))->add(T_('th',true)->add(''));
			$table->add($tr);

			foreach ($temp_code_list as $value) { 
				if ($value == "") continue;
					
				$arr = explode(":", $value);
				$arr1 = array_shift($arr);

				$tr = T_('tr',true)->add(T_('td', true)->add($arr1))->add(T_('td',true)->add(implode(":", $arr)));

				$table->add($tr);
			}

			$code_list = $table->toString();
		}

		return $code_list;
	}
}

?>