<?

import("php.db.DBData");

class ParamData extends DBData 
{
	public function __construct($db = null, $table = null) { 
		parent::__construct($db, $table);
	}

	public function getTestCode($value_list) { 
		$type = ucwords($this->getConnector()->getAttribute("program"));

		$method = "getTestCode".$type;

		return call_user_func(array($this, $method), $value_list, $proc_name);

	}

	public function getTestCodeOracle($value_list) {

	}

	public function getTestCodeCubrid($value_list) {

	}

	// mssql  
	public function getTestCodeMssql($proc_data) { 
		$value_list = $proc_data->value_list;
		$field_list = $proc_data->field_list;
		$default_list = $proc_data->default_list;

		$declare_list	= array();		//  
		$set_list		= array();		// ⺻ Ҵ
		$param_list		= array();		// Ű Ʈ
		$proc_name		= $proc_data->name;
		$result_list	= array();		//    

		$this->saveIndex();

		while($this->next()) { 
			if ($default_list[$this->param_name]) {  
				$temp = $default_list[$this->param_name];
			} else { 
				$temp = '';
			}

			$type_string = $this->getTypeStringMssql($this->param_type, $this->param_length);
			$default_string = $this->getDefaultStringMssql($this->param_type, $temp);

			// ʱȭ  
			if ($this->param_inout == 'IN') { 
				$set_list [] = sprintf("set %s = %s  -- %s", $this->param_name, $default_string, $field_list[$this->param_name]);
			}

			//  
			$declare_list[] = sprintf("declare %s %s", $this->param_name, $type_string);

			// Ű Ʈ  
			$param_list[] = IF2_($this->param_inout, 'IN', $this->param_name, $this->param_name." output");

			//   Ʈ  
			if ($this->param_inout == 'OUT') { 
				$result_list[] = sprintf("%s %s", $this->param_name, str_replace("@", "", $this->param_name));
			}
		}

		// ƿǲ    
		if ($field_list['RETURN_TYPE']) { 
			$temp_type = $field_list['RETURN_TYPE'];
			$temp_length = $field_list['RETURN_LENGTH'];
			$temp_string = $this->getTypeStringMssql($temp_type, $temp_length);

			//  ߰ 
			$declare_list[] = "declare @RETURN_VALUE ".$temp_string;

			//  ߰ 
			$result_list[] = "@RETURN_VALUE RETURN_VALUE";

			$return_code = "@RETURN_VALUE =";
		}

		if (count($declare_list) > 0) { 
			$all = "<span style='color:red'>--  </span>";
			$all .= str_repeat(PHP_EOL, 2);
			$all .= implode(PHP_EOL, $declare_list);
			$all .= str_repeat(PHP_EOL, 2);
		}

		if (count($set_list) > 0) { 
			$all .= "<span style='color:red'>-- ʱȭ </span>";
			$all .= str_repeat(PHP_EOL, 2);
			$all .= implode(PHP_EOL, $set_list);
			$all .= str_repeat(PHP_EOL, 2);
		}

		$all .= "<span style='color:red'>--  </span>";
		$all .= str_repeat(PHP_EOL, 2);
		$all .= sprintf("exec %s %s %s", $return_code, $proc_name, implode(", ", $param_list));
		$all .= str_repeat(PHP_EOL, 2);

		if (count($result_list) > 0) { 
			$all .= "<span style='color:red'>--  </span>";
			$all .= str_repeat(PHP_EOL, 2);
			$all .= sprintf("select %s " , implode(", ", $result_list));
		} 

		$this->returnIndex();

		return $all;
	}

	public function getTypeStringMssql($param_type, $param_length) { 
			switch($param_type) { 
			case "varchar": 
			case "char": 
			case "nvarchar": 
			case "nchar": 
				$type_string		= sprintf("%s(%d)", $param_type, $param_length);
				break;
			default : 
				$type_string		= $param_type ;
				break;
			}

			return $type_string;
	}

	public function getDefaultStringMssql($param_type, $default_value) { 
			switch($param_type) { 
			case "varchar": 
			case "char": 
			case "nvarchar": 
			case "nchar": 
			case 'text' : 
			case 'datetime':
			case 'smalldatetime':
				$default_string		= sprintf("'%s'", $default_value);
				break;
			default : 
				$default_string		= sprintf("%0s", $default_value);
				break;
			}

			return $default_string;
	}

}

?>