<?php

import("php.db.DBClient");
import("php.net.ftp.FtpClient");
import("php.net.netdrive.NetdriveClient");

class ServiceData extends DBData
{
	public function __construct($db = null, $table = null)
	{
		parent::__construct($db, $table);
	}

	public function selectService($type = 'DB', $hasNext = false) {
		$type = strtoupper($type);
		$this->select(" service_type = '{$type}' order by servers_num, name", $hasNext);
	}

	// Ÿ̽  
	public function isDatabase($db) { 
		$arr = explode(" ", $this->program);
		$db = strtoupper($db);

		return ($arr[0] == $db);
	}

	//   
	public function isVersion($version) { 
		$arr = explode(" ", $this->program);
		$version = strtoupper($version);

		return ($arr[1] == $version);
	}

	// Ÿ̽    
	public function is($str){
		$str = strtoupper($str);

		return ($this->program == $str);
	}

	//  
	public function createDB() { 
		$arr = explode(" ", $this->program);
		$db_class = ucwords($arr[0]);

		$db = null;

		if ($this->isDatabase($db_class)) { 
			$db = DBClient::createConnector($db_class, $this->name);
			$db->connect();
		} 

		return $db;
	}

	public function createFtp() { 
		$ftp = new FtpClient();
		$ftp->set($this->name);
		$ftp->connect();
		$ftp->login();
		$ftp->passive();

		return $ftp;		
	}

	public function createNetdrive()
	{
		$netdrive = new NetdriveClient();
		$netdrive->set($this->name);
		$netdrive->connect();

		return $netdrive;
	}

	//   
	public function createConnector() { 
		if ($this->service_type == 'FTP') { 
			return $this->createFtp();
		} else if ($this->service_type == 'DB'){ 
			return $this->createDB();
		} else if ($this->service_type == 'NETDRIVE') {
			return $this->createNetdrive();
		}

		return null;
	}


}



?>