<?php

$sql = "
select 
	TABLE_NAME			AS TABLE_NAME, 
	ORDINAL_POSITION	AS ORDINAL_POSITION,
	COLUMN_NAME			AS COLUMN_NAME,
	''					AS COLUMN_COMMENT, 
	DATA_TYPE			As DATA_TYPE, 	
	UDT_NAME			AS COLUMN_TYPE,
	case 
		when DATA_TYPE = 'character' then character_maximum_length
		else NULL
	end 				AS DATA_LENGTH, 
	numeric_precision	AS DATA_PREC,
	numeric_scale		AS DATA_SCALE,
    case 
        when is_nullable = 'NO' then ''
        else 'NULL'
    end					AS ISNULL, 
    ''					AS OPTIONS, 
	case 
		when is_identity = 'NO' then 'N' 
		else 'Y' 
	end 				AS ISAUTO,
	COLUMN_DEFAULT		AS COLUMN_DEFAULT,
	(
		select 
			'PK' as pk
		from information_schema.table_constraints A 
		join information_schema.constraint_column_usage B 
			on (A.constraint_schema = B.constraint_schema and A.constraint_name = B.constraint_name)
		where 
			B.table_name = Z.table_name
			and B.column_name = Z.column_name 
			and constraint_type = 'PRIMARY KEY'
	)					AS PK,
	''					AS UQ,
	''					AS C 
from 
	information_schema.columns Z
where 
	table_schema = '{$arr['schema_name']}' 
	and table_name = '{$arr['object_name']}'
order by 
	ORDINAL_POSITION 

";


//echo "$sql";
/*
select 
	'PK' as pk
from information_schema.table_constraints A 
join information_schema.constraint_column_usage B on (A.constraint_schema = B.constraint_schema and A.constraint_name = B.constraint_name)
where B.table_name = 'test_table' and B.column_name = 'num' and constraint_type = 'PRIMARY KEY'
*/

?>