<?php 

$sql = "
select 
		object_name(A.id)		AS TABLE_NAME,
		B.name					AS INDEX_NAME,
		A.keyno					AS COLUMN_POSITION,	
		col_name(A.id, A.colid)	AS COLUMN_NAME,
		case 
			when indexkey_property(A.id, A.indid, A.colid, 'IsDescending') = 1 then 'DESC'
			else 'ASC'
		end						AS DESCEND,
		case 
			when INDEXPROPERTY(A.id, B.name, 'IsUnique') = 1 then 'UQ'
			else ''
		end						AS UQ,
		isnull((
			select xtype 
			from sysobjects
			where name = B.name and xtype = 'PK'
		), '')					AS PK,
		case 
			when INDEXPROPERTY(A.id, B.name, 'IsClustered') = 1 then 'CLUSTERED'
			else 'NON CLUSTERED'
		end						AS INDEX_TYPE,
		''						AS ISNULL,
		''						AS COMMENT

from 
	sysindexkeys A, sysindexes B 
where 
	A.id = B.id 
	and A.indid = B.indid 
	and A.id = object_id('{$arr['object_name']}')
	and B.name not like '_WA_Sys_%'
order by 
	A.indid, A.keyno
";

/*

// ε  ϱ 
select 
	status & 1	[ignore duplicate keys],
	status & 2  [unique],
	status & 4  [ignore duplicate rows],
	status & 16  [clustered],
	status & 32  [hypothetical],
	status & 64  [statistics],
	status & 2048 [primary key],	
	status & 4096 [unique key]
from sysindexes 
where id = object_id('MgameGold_User') 
and (status & 64)  = 0 
and (status & 8388608)  = 0 
and (status & 16777216)  = 0 
and name = 'PK_MgameGold_User'

*/


?>