<?php

import("php.db.migration.TableSpec");

class CubridTableSpec extends TableSpec { 
	
	public function __construct($db = '', $table = '', $field = null, $option = null, $index = null) { 
		parent::__construct('CUBRID', $db, $table, $field, $option, $index);
	}

	protected function getColumnName() { 
		$column_name	= strtolower($this->field->column_name);

		$column_name	= str_replace(" ", "_", $column_name);
		$column_name	= str_replace(".", "_", $column_name);

		return $column_name;
	}

	protected function getDataType() { 
		if ($this->db == $this->convert_db) { 
			$data_type		= $this->field->data_type;
		} else  {
			$data_type		= TypeConvert::getRealType($this->convert_db, $this->field->meta_type);
			$type_list		= array_values($data_type);
			$type_list		= array_map('strtoupper', $type_list);

			$data_type		= ($type_list[0]) ? $type_list[0] : $type_list[1];
			$data_type		= ($data_type == 'ETC') ? 'VARCHAR' : $data_type;
		}

		return $data_type;
	}

	protected function getTypeLength($data_type) { 

		switch($data_type) { 
			case 'NUMERIC' : 
			case 'FLOAT' : 
			case 'DOUBLE PRECISION' : 
				return sprintf("(%01d,%01d)",	$this->field->data_prec,	$this->field->data_scale);
				break;
			case 'CHAR':
			case 'VARCHAR':
				return sprintf("(%01d)",		$this->field->data_length);
				break;
		}
	
		return "";
	}

	protected function getNotNull() { 
		return ($this->field->isnull == '') ? 'NOT NULL': '';
	}


	protected function getColumnDefault($data_type) { 

		if (!$this->field->column_default) { 
			return "";
		}

		switch($data_type) { 
			case 'INT':
			case 'INTEGER':
			case 'SMALLINT':
			case 'NUMERIC':
			case 'MONETARY':
				return sprintf("DEFAULT %01d",		$this->field->column_default);
				break;
			case 'CHAR':
			case 'VARCHAR':
			case 'STRING':
				return sprintf("DEFAULT '%s'",	$this->field->column_default);
				break;
			case 'NCHAR':
			case 'NCHAR VARYING':
				return sprintf("DEFAULT N'%s'",	$this->field->column_default);
				break;
			case 'DATE':
			case 'TIME':
			case 'TIMESTAMP':
				return sprintf("DEFAULT %s'%01s'",	$data_type, $this->field->column_default);
				break;
			case 'BIT VARYING':
			case 'BIT':
				return sprintf("DEFAULT B'%01s'",	$data_type, $this->field->column_default);
				break;
			default:
				return sprintf("DEFAULT %s",		$this->field->column_default);
				break;
		}

		return "";
	}

	protected function getIsAuto() { 
		return "";
	}

	protected function createHeader() {
		return $this->table;
	}

	protected function createOption() {}

	protected function createIndex() {}

	protected function createConstraints() {}

}


?>