<?php

import("php.lang.PObject");
import("php.db.migration.TypeConvert");

abstract class TableSpec extends PObject { 
	private $_attribute = array();
	private $_str		= "";
	private $_list		= array();

	public function __construct($convert_db, $db = '', $table = '', $field = null, $option = null, $index = null) { 
		$this->convert_db	= strtoupper($convert_db);
		$this->db			= strtoupper($db);
		$this->table		= $table;
		$this->field		= $field;
		$this->option		= $option;
		$this->index		= $index;

		$this->setMetaType();
	}

	// ̺   ޼ҵ 
	public static function createTableSpec($target, $source, $table, $data) { 
		$target		= strtolower($target);
		$db_list	= array('oracle','mssql','mysql','cubrid');
		$className	= ucwords($target)."TableSpec"; 

		if (!class_exists($className) && in_array($target, $db_list)) { 
			// Ŭ ߰ 
			import("php.db.migration.".$className);
		} 

		if (class_exists($className)) { 
			return 	new $className($source, $table, $data);
		} else { 
			throw new Exception("{$className} Ŭ ã  ϴ.");
		}
	}

	// Ӽ  
	public function __get($key) { 
		return $this->_attribute[strtoupper($key)];
	}

	// Ӽ  
	public function __set($key, $value) { 
		$this->_attribute[strtoupper($key)] = $value;
	}

	protected function setMetaType() { 
		$this->field->addField('meta_type');
		$this->field->saveIndex();

		while($this->field->next()) { 
			$this->field->meta_type = TypeConvert::getMetaType($this->db, $this->field->data_type);
		}

		$this->field->returnIndex();

	}
	
	/*
	 *  $field ü Ѵ. 
	 *
	 */
	protected function getFieldString() {

		// ̸ 
		$column_name		= $this->getColumnName();

		// ڷ 
		$data_type			= $this->getDataType();

		//  
		$data_length		= $this->getTypeLength($data_type);

		// not null 
		$not_null			= $this->getNotNull();

		// default 
		$column_default		= $this->getColumnDefault($data_type);

		// is_auto
		$is_auto			= $this->getIsAuto();

		$str = sprintf("\t%s %s%s %s %s %s", 
						$column_name,
						$data_type,
						$data_length,
						$not_null,
						$column_default,
						$is_auto
		);

		return $str;
	}


	/* Field String    */
	abstract protected function getColumnName() ;

	abstract protected function getDataType() ;

	abstract protected function getTypeLength($data_type) ;

	abstract protected function getNotNull();

	abstract protected function getColumnDefault($data_type) ;

	abstract protected function getIsAuto() ;


	/* ʵ ϱ  */
	protected function createField() {
		$temp = array();

		$this->field->saveIndex();

		while($this->field->next()) { 
			$temp[] = $this->getFieldString();
		}

		$this->field->returnIndex();

		return implode(",".PHP_EOL, $temp);
	}

	abstract protected function createHeader() ;

	abstract protected function createOption() ;

	abstract protected function createIndex() ;

	abstract protected function createConstraints() ;

	protected function createSpec() { 

		$spec = "-- {$this->convert_db} ".PHP_EOL;

		$spec .= "create table %s ( ".PHP_EOL;		// ̺  
		$spec .= "%s ".PHP_EOL;						// ʵ Ʈ
		$spec .= ") ".PHP_EOL.PHP_EOL;
		$spec .= "%s ;".PHP_EOL;					// ɼ Ʈ 
		$spec .= "%s ".PHP_EOL;						// ε Ʈ 
		$spec .= "%s ".PHP_EOL;						//  Ʈ 

		$spec = sprintf($spec, 
								$this->createHeader(),
								$this->createField(),
								$this->createOption(),
								$this->createIndex(),
								$this->createConstraints()
				);

		return $spec ;
	}

	public function toString() { 
		return $this->createSpec();
	}

	public function display() { 
		print_p($this->createSpec());
	}
}


?>