<?php
/**
 * @import php.lang.PObject
 */
import("php.lang.PObject");

/**
 * @package php.lang
 */

// 
session_start();

//    
function GV_($type) { 

	if (is_array($type) ) return $type;

	$type = strtoupper($type);
	switch($type) { 
	case 'POST' :		return $_POST;
	case 'GET' :		return $_GET;
	case 'REQUEST' :	return $_REQUEST;
	case 'SERVER' :		return $_SERVER;
	case 'SESSION' :	return $_SESSION;
	case 'COOKIE' :		return $_COOKIE;
	case 'ENV' :		return $_ENV;
	default	:			return $type;
	}
}

/**
 * $_GET   ޱ 
 * ʵ忡  ٸ ⺻ $_GET   Ǿ. 
 * 
 * @name G_() 
 * @param $field	get   
 * @param $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function G_($field, $value = '') {
	if (!isset($_GET[$field])) {
		$_GET[$field] = $value;
	}

	return $_GET[$field];
}

/**
 * $_POST   ޱ 
 * ʵ忡  ٸ ⺻ $_POST   Ǿ. 
 * 
 * @name P_() 
 * @param $field	get   
 * @param $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function P_($field, $value = '') {
	if (!isset($_POST[$field])) {
		$_POST[$field] = $value;
	}
	return $_POST[$field];
}

/**
 * $_SESSION   ޱ 
 * ʵ忡  ٸ ⺻ $_SESSION   Ǿ. 
 * 
 * @name  S_() 
 * @param $field	get   
 * @param $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function S_($field, $value = '') {
	if (!isset($_SESSION[$field])) {
		$_SESSION[$field] = $value;
	}
	return $_SESSION[$field];
}

/**
 * $_COOKIE   ޱ 
 * ʵ忡  ٸ ⺻ $_COOKIE   Ǿ. 
 * 
 * @name C_() 
 * @param $field	get   
 * @param $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function C_($field, $value = '') {
	if (!isset($_COOKIE[$field])) {
		$_COOKIE[$field] = $value;
	}
	return $_COOKIE[$field];
}

/**
 * $_SERVER   ޱ 
 * 
 * @name E_() 
 * @param $field	 , ҹ   
 * 
 */
function E_($field) {
	$field = strtoupper($field);

	return $_SERVER[$field];
}

/**
 * 迭 <input type="hidden" > ڿ ȯ
 * 
 * @name H_() 
 * @param $arr		迭
 * @param $prefix	key  տ  ̸
 * @return string 
 *
 */
function H_($arr, $prefix = '') {
	if (gettype($arr) != "array") {
		return "迭 ƴմϴ.";
	}

	$str = "";
	foreach ($arr as $key => $value) {
		$str .= "<input type='hidden' name='".$prefix.$key."' value='".$value."' />\n";
	}

	return $str;
}

/**
 * GET, POST  ؼ hidden ü 
 * 
 * @name HIDDEN_PRINT() 
 * @param $type		get, post, request, session, server  
 * @param $prefix	key  տ  ̸
 * @return void
 */
function HIDDEN_PRINT($type) {
	echo H_(GV_($type));
}

/**
 * GET, POST  ؼ table 
 * 
 * @name VIEW_() 
 * @param $type		get, post, request, session, server  
 * @return void
 */
function VIEW_($type) {

	$arr = GV_($type);

	if (gettype($arr) != "array") {
		return "迭 ƴմϴ.";
	}
	
	echo "<table border='1'>";
	echo  "<tr><th>Key</th><th>Value</th></tr>";
	
	foreach ($arr as $key => $value) {

			if (is_array($value)) { 
				echo  "<tr><td>";
				echo $key;
				echo "</td><td>";
				VIEW_($value);
				echo "</td></tr>";					
			} else { 

				$value = htmlspecialchars($value);
				$value = nl2br($value);
				echo  "<tr><td>";
				echo $key;
				echo "</td><td>";
				echo $value;
				echo "</td></tr>";	
			}
	}

	echo "</table>";

//	echo $str;
}

/**
 * ⺻  
 *
 * @name D_() 
 * @param $value	
 * @param $default	⺻ ''
 * @return mixed	$value $default  
 *
 */
function D_($value, $default = '') {

	if (empty($value)) {
		$value = $default;
	}

	return $value;
}

/**
 * ⺻  
 * 
 * echo IF_($a, '1', '2');   // $a 1̸ $a , ƴϸ 2 
 *
 * @name IF_() 
 * @param $value1	
 * @param $value2	
 * @param $default	⺻ ''
 * @return mixed	$value1 $value2   $value1, ٸ $default ȯ
 *
 */
function IF_($value1, $value2, $default = '') { 
	return ($value1 == $value2) ? $value1 : $default;
}

/**
 * ⺻  
 * 
 * echo IF2_($a, '1', '2', '3');   // $a 1̸ 2 , ƴϸ 3 
 *
 * @name IF2_() 
 * @param $value1	
 * @param $value2	
 * @param $return1	$value1 $value2    ȯ  
 * @param $return2	$value1 $value2  ٸ  ȯ  
 * @return mixed	
 *
 */
function IF2_($value1, $value2, $return1 = '', $return2 = '') { 
	return ($value1 == $value2) ? $return1 : $return2;
}

/*
 *   
 *
 * @name SESSION_CLOSE()
 */
function SESSION_CLOSE()
{
	session_unset();
	session_destroy();
}

/*
 * <pre> ±׸  print_r() Լ  
 *
 * @name print_p()
 * @param $arr  mixed	php   ִ  ڷ
 */
function print_p($arr) {
	echo "<pre>";
	print_r($arr);
	echo "</pre>";
}

?>