<?php

/**
 * @package php.lang
 */

/**
 * ڿ ƿƼ Ŭ
 *
 * @name	String
 * @version	1.0
 * @since	php5 or later 
 *
 */
class String 
{
	/**
	 * ڿ ڸ ( ʿ)
	 * php_mbstring.dll ε ʿ 
	 * 
	 * @access	public 
	 * @static
	 * @name	cut()
	 * @param	$str	string	ڿ
	 * @param	$length int		ڸ 
	 * @param	$subfix	string	ڿ  ڿ, ⺻ "..."
	 * @return	string
	 *
	 */
	public static function cut($str, $length, $subfix = "...") {
		if (strlen($str) <= $length) { 
			return $str;
		} else { 
			return substr($str, 0, $length).$subfix;
		}	
	}

	/**
	 * UTF-8 · ڿ ȯ  (php5 iconv  ⺻ ž)
	 * 
	 * @access	public 
	 * @static
	 * @name	getUTF8()
	 * @param	$str	  string	ȯ ڿ
	 * @param	$encoding string	 ڵ
	 * @return	string
	 *
	 */
	public static function getUTF8($str, $encoding = 'CP949') { 
		return iconv($encoding, 'utf-8', $str);
	}

	/**
	 * EUC-KR · ڿ ȯ  (php5 iconv  ⺻ ž)
	 * 
	 * @access	public 
	 * @static
	 * @name	getEUCKR()
	 * @param	$str	  string	ȯ ڿ
	 * @param	$encoding string	 ڵ
	 * @return	string
	 *
	 */

	public static function getEUCKR($str, $encoding = 'UTF-8') { 
		return iconv($encoding, 'euc-kr', $str);
	}

	/**
	 * ± ,  
	 * 
	 * @access	public 
	 * @static
	 * @name	matchTag()
	 * @param	$tagName  string	± ̸
	 * @param	$subject  string	˻ ڿ
	 * @param	$isOne	  boolean	true : One ±, false : Two ±
	 *
	 * @return	array	  tag			: ± ̸
	 *					  body			: Ī ڿ
	 *					  id			:  ̵
	 *					  attribute		: Ӽ
	 *					  description	: 
	 *					  convert		: ȯ 
	 *
	 */
	public static function matchTag($tagName, $subject, $isOne = true) {
		$tagName = strtolower($tagName);

		if ($isOne) { 
			$pattern = "/(\\[{$tagName}(=([^ ]+))? ([^\\]]+)\\])+/i";
		} else { 
			$pattern = "/(\\[{$tagName}(=([^\\] ]+))?([^\\]]*)\\]([^\\a]*)\\[\\/{$tagName}\\])+/i";
		}

		preg_match_all($pattern, $subject, $out, PREG_SET_ORDER);

		$arr = array();

		foreach ($out as $obj) {
			$arr[] = array(
						'tag'			=> $tagName,		// ± ̸
						'body'			=> $obj[1],			// Ī ڿ
						'id'			=> $obj[3],			// ̵
						'attribute'		=> $obj[4],			// Ӽ
						'description'	=> $obj[5],			// 
						'convert'		=> $obj[5]			// ȯ 
			);
		}

		return $arr;
	}

	/*
	 * ± 
	 *
	 * callback Լ ⺻ attribute, description  ̿ؼ convert ϴ Լ̴. 
	 * ⺻ ´ 
	 *
	 *  function callback_func(&$obj) { 
	 *		$obj['convert'] = str_replace("\n", "<br>", $obj['description']);
	 *	}
	 *  
	 *  callback Լ Ŭ ޼ҵ 
	 * 
	 *  class AAA { 
     *     function callback_func(&$obj) { 
     *
	 *		}
	 *	}
	 *  
	 *  $class = new AAA;
	 *  array($class, 'callback_func'); ؼ callback Լ κп ־ ָ ȴ.
	 *
	 * @access	public 
	 * @static
	 * @name	matchTagCallBack()
	 * @param	$tagName  string	± ̸
	 * @param	$subject  string	˻ ڿ
	 * @param	$isOne	  boolean	true : One ±, false : Two ±
	 * @param	$callback mixed		callback Լ
	 *
	 * @return	array	  tag			: ± ̸
	 *					  body			: Ī ڿ
	 *					  id			:  ̵
	 *					  attribute		: Ӽ
	 *					  description	: 
	 *					  convert		: ȯ 
	 *
	 */
	public static function matchTagCallBack($tagName, $subject, $isOne, $callback) { 
		if ($callback == null) return;

		$arr = String::matchTag($tagName, $subject, $isOne);

		if ($callback != null) { 
			foreach ($arr as &$obj) { 
				$obj = call_user_func($callback, $obj);
			}
		} 

		return $arr;
	}

	/**
	 * ڿ ȯ 
	 * 
	 * @access	public 
	 * @static
	 * @name	matchTagReplace()
	 * @param	$tagName  string	± ̸
	 * @param	$subject  string	˻ ڿ
	 * @param	$isOne	  boolean	true : One ±, false : Two ±
	 * @param	$callback mixed		callback Լ
	 * @return	string	ȯ $subject 		
	 */
	public static function matchTagReplace($tagName, $subject, $isOne, $callback)  { 
		
		$arr = String::matchTagCallBack($tagName, $subject, $isOne, $callback);

//		print_r($arr);

		foreach ($arr as $obj) { 
			$subject = str_replace($obj['body'].PHP_EOL, $obj['convert'], $subject);
			$subject = str_replace($obj['body'], $obj['convert'], $subject);
		}

		return $subject;
	}
}

?>