<?php
/**
 * @package php.lang
 */

/**
 * @import php.lang.PObject
 */
import("php.lang.PObject");

/**
 * Tag   Function
 *
 * ex)   $div = T_('div', true)->add('ȳ');
 *		 echo $div;
 *		 // <div>ȳ</div>
 *
 * @name	T_
 * @param	$tag		Tag ̸ 
 * @param	$hasClose	true : Two ±, false : One ±, ⺻ : false 
 * @version	1.0
 * @since	php5 or later 
 *
 */
function T_($tag, $hasClose = false) {
	return new Tag($tag, $hasClose);
}


/**
 * Tag   class
 *
 * @name	Tag
 * @version	1.0
 * @since	php5 or later 
 *
 */
class Tag extends PObject {
	/**
	 * Tag ̸
	 *
	 * @name	$tag
	 * @var		string
	 *
	 */
	protected $tag;

	/**
	 * Two ± 
	 *
	 * @access	protected
	 * @name	$hasClose
	 * @var		boolean		true : Two ±, false : One ± 
	 *
	 */
	protected $hasClose;

	/**
	 * Ӽ Ʈ 
	 *
	 * @access	protected
	 * @name	$attribute
	 * @var		array
	 *
	 */
	protected $attribute = array();

	/**
	 * Ÿ Ʈ 
	 *
	 * @access	protected
	 * @name	$style
	 * @var		array
	 *
	 */
	protected $style = array();

	/**
	 * data Ʈ 
	 *
	 * @access	protected
	 * @name	$data
	 * @var		array
	 *
	 */
	protected $data = array();

	/**
	 * 
	 *
	 * @access	public
	 * @construct 
	 * @name	__construct
	 * @param	$tag	string		± ̸ 
	 * @param	$close	boolean		Two ± 
	 *
	 */
	public function __construct($tag, $close = false)
	{
		$this->tag = strtolower($tag);
		$this->hasClose = $close;
	}

	/**
	 * Ÿ ߰ϱ 
	 *
	 * @access	public
	 * @name	addStyle()
	 * @param	$key	string		Ÿ ̸
	 * @param	$value	string		Ÿ 
	 *
	 */
	public function addStyle($key,  $value)
	{
		$this->style[$key] = "$key : $value";

		return $this;
	}

	/**
	 * Ÿ 迭 ߰ϱ 
	 *
	 *  ex)   $obj->setStyle(array('width'=>'100px', 'height' =>'100px'));
	 *
	 * @access	public
	 * @name	setStyle()
	 * @param	$arr	array		Ÿ Ʈ 
	 * @return	object
	 */
	public function setStyle($arr)
	{
		foreach ($arr as $key => $value) {
			$this->addStyle($key, $value);
		}

		return $this;
	}


	/**
	 * Ÿ ڿ  
	 *
	 * @access	protected
	 * @name	collectStyle()
	 * @return	string 
	 */
	protected function collectStyle()
	{
		return implode(";", $this->style);

	}

	/**
	 * Ӽ ߰ϱ 
	 *
	 * @access	public
	 * @name	addAttribute()
	 * @param	$key	string		Ӽ ̸
	 * @param	$value	string		Ӽ 
	 * @return	object 
	 */
	public function addAttribute($key, $value)
	{
		$this->attribute[$key] = "$key='$value'";

		return $this;
	}

	/**
	 * Ӽ 迭 ߰ϱ 
	 *
	 *  ex)   $obj->setAttribute(array('width'=>'100px', 'height' =>'100px'));
	 *
	 * @access	public
	 * @name	setAttribute()
	 * @param	$arr	array		Ӽ Ʈ
	 * @return	void
	 */
	public function setAttribute($arr) {
		foreach ($arr as $key => $attr) {
			$this->addAttribute($key, $attr);
		}

		return $this;
	}

	/**
	 * Ӽ ڿ  
	 *
	 * @access	protected
	 * @name	collectAttribute()
	 * @return	string 
	 */
	public function collectAttribute()
	{
		return implode(" ", $this->attribute);
	}

	/**
	 * Ÿ ߰ϱ, Ÿz PObject ϴ Ŭ Ϲ ڷ θ Ѵ.
	 *
	 * @access	public
	 * @name	add()
	 * @param	$obj	mixed	php  ڷ 
	 * @return	object	Tag ü ڽ 
	 */
	public function add($obj) {
		$this->data[] = PObject::getObjValue($obj);

		return $this;
	}

	/**
	 * ڿ ȯ
	 *
	 * @access	public
	 * @name	toString()
	 * @return	string
	 * @override
	 */
	public function toString()
	{

		$str = "<{$this->tag} ";

		if ($temp = $this->collectAttribute()) {
			$str .= " $temp ";
		}

		if ($temp = $this->collectStyle()) {
			 $str .= " style=\"$temp\"";
		}

		// one tag 
		if ($this->hasClose) {

			$str .= ">";
			
			if (count($this->data) > 0 ) {
				$str .= implode("", $this->data);
			}
			
			$str .= "</{$this->tag}>\n";
		}	
		// two tag 
		else {


			$str .= "/>\n";
		}

		return $str;
	}
}

?>