<?

import("php.lang.PObject");
import("php.net.ftp.FtpConfig");
import("php.net.ftp.FtpData");
import("php.net.IConnector");
import("php.util.ArrayUtil");

class FtpClient extends PObject implements IConnector {

	private $_attribute = array();

	public $protocol = "FTP";

	private $id;
	private $pass;
	private $host;
	private $sub;
	private $os;
	private $port;
	private $start_url;

	private $con;
	private $result;

	public function __construct($host = '', $id = '', $pass = '', $sub = '', $os = 'LINUX', $port = '21', $start_url = '') {

		$this->setAttribute('program',		"FTP");
		$this->setAttribute('host',			$host);
		$this->setAttribute('id',			$id);
		$this->setAttribute('pass',			$pass);
		$this->setAttribute('sub',			$sub);
		$this->setAttribute('os',			$os);
		$this->setAttribute('port',			$port);
		$this->setAttribute('start_url',	$start_url);
	}

	public function set($name) {
		$name = strtoupper($name)."_".$this->getAttribute("program");

		$this->setAttribute('HOST',			constant("{$name}_HOST"));
		$this->setAttribute('ID',			constant("{$name}_ID"));
		$this->setAttribute('PASS',			constant("{$name}_PASS"));
		$this->setAttribute('SUB',			constant("{$name}_SUB"));
		$this->setAttribute('OS',			constant("{$name}_OS"));
		$this->setAttribute('PORT',			constant("{$name}_PORT"));
		$this->setAttribute('START_URL',	constant("{$name}_START_URL"));

	}

	public function setAttribute($key, $value) { 
		$this->_attribute[strtoupper($key)] = $value;
	}

	public function getAttribute($key) { 
		return $this->_attribute[strtoupper($key)];
	}

	public function __get($key) { 
		return $this->getAttribute($key);
	}

	public function __set($key, $value) { 
		$this->setAttribute($key, $value);
	}

	public function getSub() { 
		return $this->getAttribute('sub');
	}

	public function getStartUrl() { 
		return $this->getAttribute('start_url');
	}

	public function connect() { 
		$this->con = ftp_connect($this->getAttribute('host'), $this->getAttribute('port'));
	}

	public function login() { 
		$this->result = ftp_login($this->con, $this->getAttribute('id'), $this->getAttribute('pass'));
	}

	public function createData($result) { 
		$data = new FtpData($this);

		foreach ($result as $a)  {
			$data->add($a);
		}

		return $data;
	}

	public function getData($path) { 
		$arr = $this->getFileList($path);

		return $this->createData($arr);
	}

	public function getFileList($path = '', $isLoop = false ) { 

		$total = $this->getAttribute('sub').$path;

		$temp = ftp_rawlist($this->con, $total);
		$arr = array();

		foreach ($temp as $t) { 
			$method = "getDescriptionFile".ucwords($this->getAttribute('os'));
			$arr[] = call_user_func(array($this, $method), $t);
		}
		
		return $arr;
	}

	public function getDescriptionFileLinux($str) { 
		$arr = explode(" ", $str);

		foreach ($arr as $value) {
			if (trim($value) != '' && $value != '->') { 
				$temp[] = $value;
			}
		}

		$isDir = (substr($temp[0], 0, 1) == 'd') ? 'D' : '';
		$isLink = (substr($temp[0], 0, 1) == 'l') ? 'L' : '';

		$temp2 = array(
			'dir'		=> ($isDir) ? $isDir : $isLink ,                                      // 丮   
			'auth'		=> substr($temp[0], 1),												  //            
			'num'		=> $temp[1],														  // inode          
			'user'		=> $temp[2],														  // 	      
			'group'		=> $temp[3],														  // ׷       
			'capacity'	=> $temp[4],														  // 뷮           
			'date'		=> date('Y-m-d H:i', strtotime("{$temp[5]} {$temp[6]} {$temp[7]}")),  //   ¥	
			'filename'	=> $temp[8],														  //  ̸      
			'link'		=> $temp[9],														  // ũ 	  
			'ext'		=> ($isDir) ? '' : array_pop(explode(".", $temp[8]))				  // Ȯ         
		);

		return $temp2;
	}

	public function getDescriptionFileWindows($str) { 
		$arr = explode(" ", $str);
		$temp = ArrayUtil::filter($arr);

		/*
		 * 0 : ¥  --  09-26-06
		 * 1 : ð  ð:PM  03:24PM
		 * 2 : <DIR> Ǵ 뷮
		 * 4 : ̸ 
		 */

		// ð  
		$str = "{$temp[0]} {$temp[1]}";
		$temp_date = sscanf("{$temp[0]} {$temp[1]}", "%2d-%2d-%2d %2d:%2d%s");

		if ($temp_date[5] == 'PM' && ($temp_date[3] >= 1 && $temp_date[3] <= 11)) { 
			$temp_date[3] += 12;
		}

		$temp_date[2] += 2000;

		$str = sprintf("%04d-%02d-%02d %02d:%02d:00", $temp_date[2], $temp_date[0], $temp_date[1], $temp_date[3], $temp_date[4]);

		// 丮  Ȯ 
		$isDir = ($temp[2] == '<DIR>') ? 'D' : '';

		$temp2 = array(
			'dir'		=> $isDir,												// 丮 
			'auth'		=> '',													// 
			'num'		=> '',													// inode
			'user'		=> '',													// 	
			'group'		=> '',													// ׷
			'capacity'	=> (!$isDir) ? $temp[2] : '',							// 뷮
			'date'		=> date('Y-m-d H:i', strtotime($str)),					//   ¥	
			'filename'	=> $temp[3],											//  ̸ 
			'link'		=> '',													// ũ 	
			'ext'		=> ($isDir) ? '' : array_pop(explode(".", $temp[3]))	// Ȯ 
		);

		return $temp2;
	}

	public function isDirectory($path = '/') { 
		$temp = $this->getAttribute('sub').$path;

		if (ftp_chdir($this->con, $temp)) { 
			ftp_cdup($this->con);
			return true;
		} else { 
			return false; 
		}
	}

	public function command($cmd) { 
		return ftp_exec($this->con, $cmd);
	}

	// нú  ȯ , ⺻ true
	public function passive($value = true) {
		return ftp_pasv($this->con, $value);
	}

	//  
	public function deleteFile($path) { 
		$temp = $this->getAttribute('sub').$path;
		ftp_delete($this->con, $temp);
	}	

	//  丮 
	public function currentDirectory() { 
		return ftp_pwd($this->con);
	}

	// ε 
	public function upload($destination, $source, $type = FTP_BINARY) { 
		return ftp_put($this->con, $destination, $source, $type); 
	}

	/**
	 * ٿε 
	 *
	 * local_file  :  ̸  
	 * server_file :  , δ ftp   Ѵ. 
	 *				   α ؼ ó  丮 /home/testuser/ ٰ̾ ġ 
	 *				  ftp δ /home/testuser/log/logfile.txt  ߿ 
	 *				 /log/logfile.txt  ġ ٿε带   ִ. 
	 *
	 */
	public function download($local_file, $server_file, $type = FTP_BINARY) {
		return ftp_get($this->con, $local_file, $server_file, $type);
	}

	public function close() { 
		ftp_close($this->con);
	}
}

?>