<?

import("php.openapi.OpenApi");

//   Ű ٲּ.
define("NAVER_API_SEARCH_KEY", '9068b44452c11acd7ac32e7a5c2ed53a');

/**
 * ̹ open api ˻ Ŭ 
 */
class NaverApi extends OpenApi { 
	private $target_list = array();

	public function __construct() { 
		parent::__construct('http://openapi.naver.com/search');

		$this->setTargetList();

		$this->key		= NAVER_API_SEARCH_KEY;
		$this->query	= '';
		$this->display	= 5;
		$this->start	= 1;

		/*
			kin  : 
			blog : α
		*/
		$this->target	= 'kin';

		/*
			sim: 絵 
			date: ¥ 
			count: ȸ 
			point:  
		*/
		$this->sort		= 'sim';
	}

	public function setAttribute($key, $value) { 
		if (strtolower($key) == 'target') { 
			$value = D_($this->target_list[$value], $value);
		}

		parent::setAttribute($key, $value);
	}

	public function addTargetList($key, $target) { 
		$this->target_list[$key] = $value;
		$this->target_list[$value] = $value;
	}

	public function setTargetList() { 

		// ˻   
		$this->addTargetList('',	'kin');
		$this->addTargetList('α',	'blog');
		$this->addTargetList('ڷ', 'doc');
		$this->addTargetList('',	'webkr');
		$this->addTargetList('å',		'book');
		$this->addTargetList('',	'shop');
		$this->addTargetList('',	'krdic');
		$this->addTargetList('Ͼ',	'jpdic');
		$this->addTargetList('',	'endic');

		// ˻    
		$this->addTargetList('ǽð',	'rank');		// ǽð ˻
		$this->addTargetList('õ',	'recmd');		// õ ˻
		$this->addTargetList('',	'adult');		//  ˻
	}

	// ˻   Ÿ
	public function getData($encoding = 'CP949') { 
		$xml = $this->getXml();

		$data = new OpenApiData();

		if ($xml->error_code) { 
			$data->setAttribute('error_code',		$xml->error_code);
			$data->setAttribute('error_message',	iconv('UTF-8', $encoding, $xml->message));

			return $data;
		}

		$data->setAttribute('title',		iconv('UTF-8', $encoding, $xml->channel->title));
		$data->setAttribute('link',			iconv('UTF-8', $encoding, $xml->channel->link));
		$data->setAttribute('description',	iconv('UTF-8', $encoding, $xml->channel->description));
		$data->setAttribute('lastBuildDate', date('Y-m-d H:i:s', strtotime($xml->channel->lastBuildDate)));
		$data->setAttribute('total',		$xml->channel->total);
		$data->setAttribute('start',		$xml->channel->start);
		$data->setAttribute('display',		$xml->channel->display);

		// ʵ 
		$data->setFields(array('title','link','description'));
		
		foreach ($xml->channel->item as $arr) { 
			$temp_arr = array(
				'title'			=> iconv('UTF-8', $encoding, $arr->title),	
				'link'			=> iconv('UTF-8', $encoding, $arr->link),	
				'description'	=> iconv('UTF-8', $encoding, $arr->description)
			);

			$data->add($temp_arr);
		}

		return $data;
	}

	public function getPageData($page, $pagesize, $encoding = 'CP949') { 
		$this->start	= $pagesize * ($page-1) + 1 ;
		$this->display  = $pagesize ;

		return $this->getData($encoding);
	}

}


?>