<?
import("php.lang.PObject");
import("php.lang.String");
import("php.openapi.OpenApiData");

class OpenApi extends PObject { 
	private $_encoding	= 'UTF-8';
	private $_base_encoding	= 'CP949';
	private $_link		= '';
	private $_attribute = array();

	public function __construct($link = '') { 
		$this->setLink($link);
	}

	public function setLink($link) { 
		$this->_link = $link;
	}

	public function getLink() { 
		return $this->_link;
	}

	public function setEncoding($encoding) { 
		$this->_encoding = $encoding;
	}

	public function getEncoding() { 
		return $this->_encoding;
	}

	public function setBaseEncoding($encoding) { 
		$this->_base_encoding = $encoding;
	}

	public function getBaseEncoding() { 
		return $this->_base_encoding;
	}


	public function getAttribute($key) { 
		return $this->_attribute[strtolower($key)];
	}

	public function setAttribute($key, $value) { 
		$this->_attribute[strtolower($key)] = $value;
	}

	public function __get($key) { 
		return $this->getAttribute($key);
	}

	public function __set($key, $value) { 
		$this->setAttribute($key, $value);
	}

	public function getQuery() { 
		
		if ($this->getEncoding()) { 
			foreach ($this->_attribute as $key => $value) { 
				$this->_attribute[$key] = iconv($this->getBaseEncoding(), $this->getEncoding(), $value);
			}
		}

		$query = http_build_query($this->_attribute);

		return $query;
	}

	public function getFullLink() { 

		$query = $this->getQuery();

		$str = $this->getLink()."?".$query;

		return $str;
	}


	// Ÿ  
	public function getData() { 
		$data = new OpenApiData();

		return $data;
	}


	public function getXml() { 

		$xml = simplexml_load_file($this->getFullLink());

		return $xml;
	}
}
?>