<?php

import("php.lang.PObject");
import("php.lang.String");
import("php.parser.tag.*");

class TagParser extends PObject { 
	private $str;

	private $tagList = array();
	private $replaceList = array();
	private $prevReplaceList = array();

	private $idList = array();

	public function __construct($str) {
		$this->set($str);

		// ± ȯ
		$this->addTagList('link', array('̵', '', 'link'),		true);
		$this->addTagList('view', array('', '', 'view'),		true);
		$this->addTagList('code', array('ڵ', 'code', ''),		false);
//		$this->addTag('table',	false);
//		$this->addTag('graph',	false);

		// Ϲ ڿ ٲٱ 

		$this->addReplace(PHP_EOL, "<br />".PHP_EOL);
		$this->addReplace("\t", str_repeat("&nbsp;", 4));
	}

	public function set($str) { 
		$this->str = $str;
	}

	//  Ŭ Ǵ  ±׸ ÿ Ѵ.
	public function addTagList($class, $name = array(), $isOne = true) { 
		foreach ($name as $n) {
			$this->addTag($class, $n, $isOne);
		}
	}

	// Ŭ ؼ ±׸ Ѵ. 
	public function addTag($class, $name, $isOne = true) { 
		$this->tagList[$name] = array($class, $name, $isOne);
	}

	// ± ȯ  ٲ  Ѵ.
	public function addReplace($name, $replace) { 
		$this->replaceList[] = array($name, $replace);
	}

	// ± ȯ  ٲ  Ѵ.
	public function addPrevReplace($name, $replace) { 
		$this->prevReplaceList[] = array($name, $replace);
	}

	public function addId($obj) { 
		$this->idList[$obj->get('id')] = $obj;
	}

	// ȯ 
	public function convert() { 
		$str = $this->str; 

		//  ȯ ۾
		foreach ($this->prevReplaceList as $replace) { 
			$str = str_replace($replace[0], $replace[1], $str);
		}

		// ± ȯ ۾
		foreach ($this->tagList as $tag) { 
			$str = String::matchTagReplace($tag[1],	$str, $tag[2],	 array($this, 'replaceTag'));
		}

		//  ȯ ۾
		foreach ($this->replaceList as $replace) { 
			$str = str_replace($replace[0], $replace[1], $str);
		}

		return $str;
	}

	public function toString() { 
		return $this->convert();
	}

	function replaceTag(&$obj) { 
		$class = ucwords($this->tagList[$obj['tag']][0])."Tag";

		$obj['tag'] = $this->tagList[$obj['tag']][0];

		if (class_exists($class)) { 
			$tag = new $class($obj);
			$temp = $tag->toArray();

			if ($tag->get('id')) { 
				$this->addId($tag);
				$temp['convert'] = '';
			}  

			return $temp;
		}

		return array();
	}
}


?>