<?

import("php.db.Data");
import("php.util.calendar.CalendarUnit");

class CalendarData extends PObject {
	private $year;
	private $month;
	private $day;

	private $data;
	private $title;
	private $id;

	public function __construct($year = '' , $month = '' , $day = '') {
		parent::__construct();

		$this->setCalendar($year, $month, $day);
		$this->setTitle(array('','','ȭ','','','',''));
	}

	/* ¥  */
	public function setCalendar($year, $month, $day) { 
		$this->year		= (empty($year))	? date('Y') : $year ;
		$this->month	= (empty($month))	? date('m') : $month ;
		$this->day		= (empty($day))		? date('d') : $day ;
			
		$this->createCalendar();
	}

	public function setId($id) {
		$this->id = $id;
	}

	public function __get($key) { 
		return $this->{$key};
	}

	public function __set($key, $value) { 
		$this->{$key} = $value;
	}

	public function getDate() {
		return sprintf("%d %d %d", $this->year, $this->month, $this->day);
	}

	public function setTitle(array $arr) { 
		$this->title = $arr;
	}

	/* ù   */
	public function getFirstDayOfWeek() {
		return date('w', mktime(0, 0, 0, $this->month, 1, $this->year));
	}

	/*   */
	public function getLastDay() {
		return date('t', mktime(0, 0, 0, $this->month, $this->day, $this->year));
	}

	/* ޷   */
	private function createCalendar() {
		$arr = array();
		$dayCount	= $this->getLastDay();


		for ($count = 0; $count < $dayCount; $count++) {
			$arr[$count] = new CalendarUnit($count+1);
		}

		$this->data = $arr;
	}

	/*    */
	public function get($day) { 
		return $this->data[$day-1];
	}

	/*  ߰ϱ */
	public function set($day, $obj)  {
		$this->data[$day-1]->add($obj);
	}

	public function getList() 
	{
		$startIndex = $this->getFirstDayOfWeek();
		$dayCount = $this->getLastDay();

		$arr = array_fill(0, 41, '');
	
		// 迭 Ÿ  
		for ($i = $startIndex, $count = 0; $count < $dayCount; $count++, $i++) {
			$arr[$i] = $this->data[$count];
		}

		return $arr;
	}

	public static function getDayOfWeek($i) {
		switch($i) {
		case 0: return 'Sunday';
		case 1: return 'Monday';
		case 2: return 'Tuesday';
		case 3: return 'Wednesday';
		case 4: return 'Thursday';
		case 5: return 'Friday';
		case 6: return 'Saturday';
		}
	}

	public function toTable() {
		$arr = $this->getList();

		$table = T_('table', true);
		$table->addAttribute('height', '100%');
		$table->addAttribute('width', '100%');

		// ÷Ӽ  
		$colgroup = T_('colgroup', true);
		
		for($i = 0; $i < 7; $i++) {
			$col = T_('col');
			$col->addAttribute("id", CalendarData::getDayOfWeek($i));

			if ($i == 0) { 
				$bgcolor = '#FEEFF5';
			} else if ($i == 6) { 
				$bgcolor = "#EDEEFE";				
			} else {
				$bgcolor = '';
			}

			if ($bgcolor) { 
				$col->setAttribute( array('bgcolor' => $bgcolor) );
			}

			$colgroup->add($col);
		}	

		$table->add($colgroup);


		// ŸƲ  
		$tr = T_('tr', true);
		$tr->addAttribute('height', 25);

		for ($i = 0; $i < 7; $i++) {
			$td = T_('th', true)->add($this->title[$i]);
			$tr->add($td);
		}

		$table->add($tr);


		// ̺ Ÿ Է

		for($row = 0; $row < 6; $row++) {
			$tr = T_('tr', true);

			for($col = 0; $col < 7; $col++) {
				$index = $row*7 + $col;
				$day = (PObject::isObject($arr[$index])) ? $arr[$index]->get() : '';

				$str = empty($arr[$index]) ? '&nbsp;' : PObject::getObjValue($arr[$index]);
				$bgcolor = (PObject::isObject($arr[$index]) && $arr[$index]->getCurrent()) ? "#e7e7e7" : "";
				
				$td = T_('td', true);
				$td->setAttribute(
					array(
						'align'		=> 'left',
						'valign'	=> 'top',
						'bgcolor'	=> $bgcolor
					)
				);

				$td->add($str);

				$tr->add($td);
			}

			$table->add($tr);
		}

		return $table;
	}

	public function toString() {
		return $this->toTable()->toString();
	}
}

?>