<?php

import("php.util.calendar.CalendarData");


/*
 * ̺Ʈ, job, Ÿ   Ŭ
 */
class Scheduler { 
	private $cal;

	public function Scheduler($year = '' , $month = '' , $day = '') { 
		$this->cal = new CalendarData($year, $month, $day);
		$this->setScheduler();
	}

	private function setScheduler() { 
		$last = $this->cal->getLastDay();


		$image_list = array('job', 'event', 'diary', 'bug');

		for ($i = 1; $i <= $last; $i++) {

			$temp_query = array(
				'year'	=> $this->cal->year,
				'month' => $this->cal->month,
				'day'	=> $i
			);

			$query = http_build_query($temp_query);

			$arr = array();
			foreach($image_list as $img) { 
				$arr[] = "<a href='/{$img}/write.mgame?{$query}'><img src='/images/icon/calendar/icon_{$img}.jpg' alt='{$img}' title='{$img}' align='absmiddle'/></a> ";
			}

			$value = "<a href='list.mgame?{$query}'>{$i}</a>";

			$str = implode(" ", $arr);

			$obj = $this->cal->get($i);


			$obj->setValue($value);
			$obj->setTitle($str);

			if ($i == $this->cal->day) { 
				$obj->setCurrent(true);
			}
		}
	}

	public function getDate() {
		return $this->cal->getDate();
	}

	public function toTable() { 
		return $this->cal->toTable();
	}

	public function toString() 
	{
		return $this->cal->toString();
	}

	// -1 : Ѵ 
	// 1 : Ѵ  
	public function getDiffMonth($month) { 
		$make = mktime(0,0,0, $this->cal->month + ($month), 1, $this->cal->year);
		$arr = array();

		list($arr['year'], $arr['month'], $arr['day']) = sscanf(date('Y-m-d', $make), "%04d-%02d-%02d"); 

		$arr['day'] = (date('t', $make) < $this->cal->day) ? date('t', $make) : $this->cal->day;

		return $arr;
	}
}


?>