<?php
/**
 * Sqlite
 *
 * @package php.db
 */

import("php.db.DBClient");
import("php.db.SqliteConfig");

/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = sqlite_('test_db', true); </code>
 *
 * @see DB_()
 * @param string $db ȯ漳   ̸
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Sqlite DBClient  ü
 */
function SQLITE_($db, $isConnect = false) { 
	return DB_('sqlite', $db, $isConnect);
}

/**
 * sqlite  Ŭ 
 *
 * @package php.db
 */
class Sqlite extends DBClient {

	/**
	 * 
	 *
	 */
	public function __construct($host = '', $db = '', $schema = '', $version = '') {
		$program		= strtoupper(__CLASS__);
		parent::__construct($program, $host, '', '', '', $db, $schema, $version);
	}

	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	protected function _connect() { 
		return sqlite_open($this->host.$this->db);
	}

	/** 
	 * DB ϱ 
	 */
	protected function _selectDb() { 
		return true;
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return sqlite_changes($this->con);
	}

	/**
	 *  ݱ 
	 */
	public function close()
	{
		if ($this->con) { 
			sqlite_close($this->con);
		}
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */	
	public function error() {
		return sqlite_error_string(sqlite_last_error($this->con)) ;
	}

	/**
	 * ڿ escape	
	 * 
	 * @param string $str  escape  ڿ 
	 * @return string escape  ڿ
	 */
	public function escape($str) { 
		return sqlite_escape_string ($str);
	}


	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result) {
		return sqlite_fetch_array($result, SQLITE_ASSOC);
	}

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) {
		return true;
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return sqlite_num_fields($result);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		return sqlite_field_name($result, $i);
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) {
		return "varchar";
	}

	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * @param string $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @param string $baseClass  DBData   Ŭ , ⺻ DBData  
	 * @return DBData
	 */
	function getPageData($query, $page, $count = 10,$baseClass = 'DBData')
	{
		//  ϱ 
		$start = ($page-1)*$count;

		$query .= " limit $start, $count";

		return $this->getData($query, false, $baseClass);
	}

	/** 
	 * Ϲ   
	 * 
	 * @param string $sql  query 
	 * @return resource  resource
	 */
	public function query($sql) {
		$this->result = sqlite_query($this->con, $sql);
		return $this->result;
	}

	/**
	 * Ŀ ̵ 
	 * 
	 * @param int $count ̵ų ġ,  0 
	 * @return bool
	 */
	function seek($count) { 
		return sqlite_seek ( $this->getResult(), $count );
	}
}

?>