<?php
/**
 * ť긮
 *
 * @package php.db
 */


/**
 * ť긮  Ŭ
 *
 * <code>
 *  $cubrid = db_('cubrid', 'testdb', true);
 *
 *  $cubrid->query("insert into testclass values ('aaaa')");
 *  echo $cubrid->getData("select * from testclass");
 * 
 *  $cubrid->close();
 * </code>
 *
 * @package php.db
 */
class Cubrid extends DBClient {

	private $tempStmt;

	private $oid		= null;

	private $cursor		= array();

	private $proc_name	= "";

	private $bind_list	= array();

	/**
	 * 
	 *
	 */
	public function __construct($option) {
		parent::__construct($option);
	}

	/**
	 * DB 
	 * 
	 * @return resource 
	 */
	protected function _connect() {
		return cubrid_connect($this->host, $this->port, $this->db, $this->id, $this->pass );
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return cubrid_affected_rows($this->getResult());
	}

	/** 
	 * set Ÿ Ӽ  ߰ 
	 *
	 * @param string $attr  Ӽ̸ 
	 * @param mixed $value Ӽ 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function addSet($attr, $value, $oid = '') { 
		return cubrid_set_add($this->getConnection(), $this->getOID($oid), $attr, $value);
	}

	/** 
	 *  seq  ߰
	 *
	 * @param string $attr  Ӽ̸ 
	 * @param mixed $value Ӽ 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function addSeq($attr, $value, $oid = '') { 
		$size = cubrid_col_size($this->getConnection(), $this->getOID($oid), $attr);

		return $this->insertSeq($attr, $size+1, $value);
	}

	/** 
	 *  oid شǴ instance  
	 *  
	 *  δ Ÿ̽ ڵ尡  ˴ϴ. 
	 *  
	 * @param string $oid oid 
	 * @return bool 
	 */
	public function drop($oid = '') { 
		return cubrid_drop($this->getConnection(), $this->getOID($oid));
	}

	/** 
	 * set Ÿ Ӽ  
	 *
	 * @param string $attr  Ӽ̸ 
	 * @param mixed $value Ӽ 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function dropSet($attr, $value, $oid = '') { 
		return cubrid_set_drop($this->getConnection(), $this->getOID($oid), $attr, $value);
	}

	/**
	 * oid Ư Ӽ   
	 * 
	 * @param string|array $attr Ӽ(ʵ) ̸ 
	 * @param string $oid Ӽ(ʵ)   ִ oid 
	 * @return mixed|array oid Ӽ 
	 */
	public function get($attr, $oid = '') { 
		if (is_array($attr)) { 
			$temp = array();

			foreach ($attr as $temp_attr) { 
				$temp[$temp_attr] = cubrid_get($this->getConnection(), $this->getOID($oid), $temp_attr);
			}

			return $temp;
		} else { 
			return cubrid_get($this->getConnection(), $this->getOID($oid), $attr);
		}
	}

	/**
	 *  oid  
	 * 
	 * @param resource $result    result 
	 * @return string result ˻ oid 
	 *
	 */
	public function getCurrentOID($result) { 
		return cubrid_current_oid($result);
	}



	/**
	 * oid   
	 *
	 * ⺻  oid  parameter  oid ȯѴ.  
	 * 
	 * @param string $oid  oid 
	 * @return string 
	 */ 
	public function getOID($oid = '') { 
		return (empty($oid)) ? $this->oid : $oid;
	}



	/** 
	 *  oid Ӽ 迭   
	 * 
	 * @param string $oid oid 
	 * @return array  
	 */
	public function gets($oid = '') { 
		return cubrid_get($this->getConnection(), $this->getOID($oid));
	}

	/** 
	 *  seq Ư  ֱ 
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param int $index  sequence index , ó ġ 1 
	 * @param mixed $value Ӽ 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function insertSeq($attr, $index, $value, $oid = '') { 
		return cubrid_seq_insert($this->getConnection(), $this->getOID($oid), $attr, $index, $value);
	}

	/**
	 * oid   Ȯ 
	 *
	 * @param string $oid  üũ oid 
	 * @return bool  oid ϸ true, ƴϸ false
	 */
	public function isInstance($oid = '') { 
		return cubrid_is_instance($this->getConnection(), $this->getOID($oid));
	}


	/** 
	 *  oid Ӽ  
	 * 
	 * @param string $attr Ӽ(ʵ)
	 * @param mixed $value Ӽ
	 * @param string $oid oid 
	 * @return bool    true, ƴϸ false
	 */
	public function put($attr, $value, $oid = '') { 
		
		$args = array($this->getConnection(), $this->getOID($oid), $attr);


		if (is_array($arr) == false) { 
			$args[] = $value;	
		} 

		return call_user_func_array('cubrid_put', $args); 
	}

	/**
	 *  Ӽ ÿ  
	 * 
	 * <code>$cubrid->puts(array('aa' => 1, 'bb' => 2, 'cc' => 3), $oid);</code>
	 *
	 * @param array $attr_list ӼƮ
	 * @param string $oid oid 
	 * @return bool
	 */
	public function puts($attr_list, $oid = '') { 
		return cubrid_put($this->getConnection(), $this->getOID($oid), $attr_list);
	}

	/**
	 * oid 
	 *
	 * @param string $oid oid 
	 */
	public function setOID($oid) { 
		$this->oid = $oid;
	}




	/** 
	 *  seq Ư  
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param int $index  sequence index , ó ġ 1 
	 * @param string $oid oid 
	 * @return bool
	 */
	public function dropSeq($attr, $index, $oid = '') { 
		return cubrid_seq_insert($this->getConnection(), $this->getOID($oid), $attr, $index);
	}

	/** 
	 *  seq Ư  ϱ (update)
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param int $index  sequence index , ó ġ 1 
	 * @param mixed $value   
	 * @param string $oid oid 
	 * @return bool
	 */
	public function putSeq($attr, $index, $value, $oid = '') { 
		return cubrid_seq_put($this->getConnection(), $this->getOID($oid), $attr, $index, $value);
	}

	/** 
	 * collection   
	 *
	 * Ӽ collection Ÿ   ´. 
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param string $oid oid 
	 * @return int 
	 */
	public function getCollectionSize($attr, $oid = '') { 
		return cubrid_col_size($this->getConnection(), $this->getOID($oid), $attr);
	}

	/** 
	 * collection Ÿ 迭 ·  (set, multiset, sequence)
	 *
	 * Ӽ collection Ÿ   迭 ɴϴ. 
	 *
	 * @param string $attr  Ӽ̸ 
	 * @param string $oid oid 
	 * @return array
	 */
	public function getCollection($attr, $oid = '') { 
		return cubrid_col_get($this->getConnection(), $this->getOID($oid), $attr);
	}

	/** 
	 *  Ÿ set, multiset, sequence   Data ü ´.
	 *
	 * collection Ÿ߿  Ŭ(̺) · Ǿ ִ   
	 * װͿ  Ÿ DBData ü ȯݴϴ. 
	 * 
	 * @param string $attr  Ӽ̸ 
	 * @param bool $isOne  ĭ   
	 * @param string $oid oid 
	 * @return DBData
	 */
	public function getOIDData($attr, $isOne = false, $oid = '') { 
		$a = $this->getCollection($attr, $this->getOID($oid));

		$data = new DBData($this);

		if (empty($a)) { 
			return $data;
		}


		$data->setFields(array_keys($this->gets($a[0])));
		$data->addField('oid');

		foreach ($a as $oid) { 
			$arr = $this->gets($oid);
			$arr['oid'] = $oid;
			$data->add($arr);
		}

		if ($isOne) { 
			$data->next();
		}

		return $data;
	}

	/** 
	 *  б lock  
	 * 
	 * @param string $oid oid 
	 * @return bool 
	 */
	public function setReadLock($oid = '') { 
		return cubrid_lock_read($this->getConnection(), $this->getOID($oid));
	}

	/** 
	 *   lock  
	 * 
	 * @param string $oid oid 
	 * @return bool 
	 */
	public function setWriteLock($oid = '') { 
		return cubrid_lock_write($this->getConnection(), $this->getOID($oid));
	}

	/** 
	 *  ݱ 
	 * 
	 * @return bool 
	 */
	public function close() {
		cubrid_disconnect($this->getConnection());
	}


	/** 
	 * commit 
	 *
	 * cubrid  ⺻ Ʈ ϱ  insert, update, delete  commit  ؾ մϴ. 
	 * select  commit ָ ϴ. 
	 * 
	 * @return bool 
	 */
	public function commit() { 
		cubrid_commit($this->getConnection());
	}

	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result) {
		return cubrid_fetch($result, CUBRID_ASSOC);
	}

	/** 
	 * result ޸  
	 *
	 * @param resource $result select  result 
	 * @return bool
	 */
	public function free($result) { 
		return cubrid_close_request($result);
	}

	/** 
	 *   ޼  
	 * 
	 * @return string  ޼ 
	 */
	public function error() {
		return cubrid_error_msg($this->getConnection());
	}

	/**
	 * Ŀ ̵ 
	 * 
	 * @param int $count ̵ų ġ
	 * @param string $origin  first, current, last, ⺻ current 
	 * @return bool
	 */
	public function seek($count, $origin = 'current') { 
		$temp_origin = constant("CUBRID_CURSOR_".strtoupper($origin));

		return cubrid_move_cursor($this->getResult(), $count, $temp_origin);
	}

	/** 
	 * Ϲ   
	 * 
	 * <code>$cubrid->query("insert into tclass values ('a')");</code>
	 *
	 * @param string|resource $query   ̳ prepare   resource
	 * @param string $option   ɼ,  oid, async, all
	 * @return resource $query  resource, ϸ false 
	 */
	public function query($query, $option = '') {
	
		$options = strtolower($option);

		if ($option == 'oid') { 
			$option = CUBRID_INCLUDE_OID;
		} else if ($option == 'async') {
			$option = CUBRID_ASYNC;
		} else if ($option == 'all') { 
			$option = CUBRID_ASYNC | CUBRID_INCLUDE_OID;
		}

		if (is_string($query)) {	// Ϲ sql 
			
			$this->addSql($query);

			$args = array($this->getConnection(), $query);

			if ($option != '') { 
				$args[] = $option;
			}

			$this->setResult(call_user_func_array('cubrid_execute', $args));

			return $this->getResult();

		} else {		// prepare ̿ ü  

			$args = array($query);

			if ($option != '') { 
				$args[] = $option;
			}

			call_user_func_array('cubrid_execute', $args);

			$this->setResult($query);

			return $this->getResult();
		}
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return cubrid_num_cols($result);
	}

	/**
	 *    ʵ ̸ Ʈ 迭 Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return array ʵ̸ Ʈ 
	 */
	public function getFieldList($result) { 
		return cubrid_column_names($result);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		$arr = $this->getFieldList($result);

		return $arr[$i];
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) {
		$arr = $this->getFieldTypeList($result);

		return $arr[$i];
	}

	/**
	 *  ġ ʵŸ Ʈ ´. 
	 *
	 * @param resource $result select   resource
	 * @return array ʵŸ Ʈ
	 */
	public function getFieldTypeList($result) {	
		return cubrid_column_types($result);
	}

	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * 
	 * @param string $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @param string $order_type   , order : order by  ¡, group : group by  ¡,  rownum ¡ 
	 * @return DBData
	 */
	public function getPageData($query, $page = 1, $count = 10, $order_type = 'order') {
		
		if (!in_array($order_type, array('order', 'group'))) { 
			die('order_type  ƲȽϴ.(order, group   ϳ ּ)');
		}
		

		//  ϱ 
		$start = ($page-1)*$count+1;
		$end = ($start+$count-1);

		if ($order_type == 'order') { 
			$query .= " for orderby_num() between {$start} and {$end} ";
		} else if ($order_type == 'group') { 
			$query .= " having groupby_num() between {$start} and {$end} ";			
		} else { 
			$query .= " and rownum between {$start} and {$end} ";
		}


		return $this->getData($query, false);
	}

	/**
	 *  Ÿ  ´ ڿ ǥ ش. 
	 *
	 * <code>
	 *  // '123'  ǥ 
	 *  echo $cubrid->getTypeString('char', '123');
	 * 
	 *  // 123  ǥ 
	 *  echo $cubrid->getTypeString('int', '123');
	 * </code>
	 * 
	 * @param string $type Ÿ ̸ 
	 * @param mixed $value ȯ  
	 * @param boolean $is_null  üũ   , true üũ, false  üũ  
	 * @return string 
	 */
	public function getTypeString($type, $value, $is_null = false ) { 
		$type = strtolower($type);
		$temp = '';

		switch ($type) { 
			case 'char':
			case 'string':
			case 'varchar':
				$temp = sprintf("'%s'", $this->escape($value));
				break;
			case 'nchar':
			case 'nchar varying':
				$temp = sprintf("N'%s'", $this->escape($value));
				break;
			case 'bit':
			case 'bit varying':
				$temp = sprintf("B'%s'", $this->escape($value));
				break;
			case 'integer': 
			case 'int': 
			case 'smallint':
				$temp = sprintf("%d", intval($value));
				break;
			case 'decimal':
			case 'double precision':
			case 'float':
			case 'monetary':
			case 'numeric':
			case 'real':
				$temp = sprintf("%f", floatval($value));
				break;
			case 'date':
			case 'time':
			case 'timestamp':
				$temp = sprintf("%s'%s'", $type, $this->escape($value));
				break;
			case 'list': 
			case 'multiset': 
			case 'sequence':
			case 'set': 
				$temp = sprintf('{%s}', $value);
				break;
			default :
				$temp = $value;
				break;
		}

		return ($is_null && is_null($value)) ? 'NULL' : $temp;
	}


	/** 
	 * ο glo Ŭ  oid  
	 *
	 * @param string $class_name  cubrid Ŭ ̸ , Ϲ glo  ϴ. 
	 * @param string $file_name   ̸ 
	 * @return resource|bool   νϽ, ƴϸ false 
	 * @see Cubrid::loadGLO(),Cubrid::printGLO(),Cubrid::saveGLO()
	 */
	 public function newGLO($class_name, $file_name) { 
		return cubrid_new_glo($this->getConnection(), $class_name, $file_name);
	 }

	/** 
	 * glo νϽ ϴ file_name 
	 *
	 * @param string $file_name   ̸ 
	 * @param resource $oid  glo νϽ
	 * @return bool ϸ true, ϸ false 
	 * @see Cubrid::newGLO(),Cubrid::printGLO(),Cubrid::saveGLO()
	 */
	 public function loadGLO($file_name, $oid = '') { 
		return cubrid_load_from_glo($this->getConnection(), $this->getOID($oid), $file_name);
	 }

	/** 
	 * glo νϽ ǥ 
	 * 
	 * <code>
	 * // ̳ʸ ״ ȭ鿡  
	 * $cubrid->printGLO($glo);
	 *
	 * // gif ̹ ȭ鿡  
	 * $cubrid->printGLO($glo, 'image/gif');
	 * </code>
	 * 
	 * @param resource $oid  glo νϽ
	 * @param string $content_type  header  content-type 
	 * @return bool ϸ true, ϸ false 
	 * @see Cubrid::loadGLO(),Cubrid::newGLO(),Cubrid::saveGLO()
	 */
	 public function printGLO($oid = '', $content_type = '' ) {

		if ($content_type) { 
			header("Content-Type : {$content_type}");
		}

		return cubrid_send_glo($this->getConnection(), $this->getOID($oid));
	 }

	/** 
	 * rollback
	 *
	 * @return bool 
	 */
	public function rollback() { 
		cubrid_rollback($this->getConnection());
	}

	/** 
	 * glo νϽ  file_name ִ Ÿ ϱ 
	 *
	 * νϽ  ٲߴϴ.
	 * 
	 * @param string $file_name glo  ϸ 
	 * @param resource $oid glo νϽ 
	 * @return bool ϸ true, ϸ false 
	 * @see Cubrid::loadGLO(),Cubrid::printGLO(),Cubrid::newGLO()
	 */
	 public function saveGLO($file_name, $oid = '') { 
		return cubrid_save_to_glo($this->getConnection(), $this->getOID($oid), $file_name);
	 }





	/**
	 * ε   ϰ ϴ ޼ҵ 
	 * 
	 * ε  ?  ǥѴ. 
	 *
	 * <code>
	 * //prepare ⺻   
	 * $sql = "select * from board where title = ?";
	 * $number = "";
	 *
	 * $stmt = $cubrid->prepare($sql);
	 * $cubrid->bind($stmt, 1, $number);
	 *
	 * echo $cubrid->getData($stmt);   or  $cubrid->query($stmt);
	 * </code>
	 *
	 * @param string $query   
	 * @param string $option ɶ oid     , 'oid' oid 
	 * @return resource prepare ޼ҵ  resource
	 * @see Cubrid::bind()
	 */
	public function prepare($query, $option = '')  { 
		$this->addSql($query);

		if (strtolower($option) == 'oid') { 
			$option = CUBRID_INCLUDE_OID;
		} 

		$args = array($this->getConnection(), $query);

		if ($option != '') { 
			$args[] = $option;
		}

		$this->setStatement(call_user_func_array('cubrid_prepare', $args));
	} 

	/** 
	 * bind ޼ҵ 
	 *
	 * @param resource $stmt prepare()  resource
	 * @param int $index ε  ġ, ⺻ 1 
	 * @param mixed $bind_value ε  
	 * @param string bind_vlaue_type ε Ÿ, ť긮忡 Ǵ ŸԸ ״ Ѵ. 
	 * @return bool
	 * @see Cubrid::prepare()
	 */
	public function bind($index = 1, $bind_value, $bind_value_type = '') { 

		$bind_value_type = strtoupper($bind_value_type);

		$args = array($this->getStatement(), $index, $bind_value);

		if ($bind_value_type != '') { 
			$args[] = $bind_value_type;
		} 

		$temp = call_user_func_array('cubrid_bind', $args);

		return $temp ;
	}

	/** 
	 * prepare  statement  
	 * 
	 * @param string|resource $query   ̳ prepare   resource
	 * @param string $option   ɼ,  oid, async, all
	 * @return resource $query  resource, ϸ false 
	 */
	public function execute($option = '') {
	
		$options = strtolower($option);

		if ($option == 'oid') { 
			$option = CUBRID_INCLUDE_OID;
		} else if ($option == 'async') {
			$option = CUBRID_ASYNC;
		} else if ($option == 'all') { 
			$option = CUBRID_ASYNC | CUBRID_INCLUDE_OID;
		}

		$args = array($this->getStatement());

		if ($option != '') { 
			$args[] = $option;
		}

		$exec = call_user_func_array('cubrid_execute', $args);

		$this->setResult($this->getStatement());

		return $exec;
	}
	
	/**
	 * ν  ü ´. 
	 * 
	 * 
	 * @see lib/php/db/DBClient#createProc($name)
	 * @return CubridProc 
	 */
	public function createProc($str, $option = 'proc') { 
		$proc = new CubridProc($this);
		$proc->name($str, $option);
		
		return $proc;
	}	
}

?>