<?php
/**
 * Mysqli
 *
 * @package php.db
 */

//import("php.db.Mysql");

/**
 * mysqli  Ŭ 
 *
 * @package php.db
 */
class Mysql_i extends Mysql {

	/**
	 * 
	 *
	 */
	public function __construct($option = array()) {
		parent::__construct($option);
	}

	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	protected function _connect() { 
		return mysqli_connect($this->host, $this->id, $this->pass, $this->db, $this->port, $this->socket);
	}

	/** 
	 * DB ϱ 
	 *
	 * @param string $db_name  Ÿ̽ 
	 * @return bool
	 */
	public function selectDB($db_name) { 
		return mysqli_select_db($this->getConnection(), $db_name);
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return mysqli_affected_rows($this->getConnection());
	}


	/**
	 *  ݱ 
	 */
	public function close()
	{
		mysqli_close($this->getConnection());
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */	
	public function error() {
		return mysqli_error($this->getConnection());
	}

	/**
	 * ڿ escape	
	 * 
	 * @param string $str  escape  ڿ 
	 * @return string escape  ڿ
	 */
	public function escape($str) { 
		return mysqli_real_escape_string($this->getConnection(), $str);
	}

	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result) {
		return mysqli_fetch_assoc($result);
	}


	public function fetchField($result, $attribute = 'name') { 
		$arr = mysqli_fetch_fields($result); 

		$temp = array();

		foreach ($arr as $value) { 
			$temp[] = $value->{$attribute};
		}
	
		return $temp;
	}

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) {
		return mysqli_free_result($result);
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return mysqli_field_count($result);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		return mysqli_fetch_field_direct($result, $i)->name;
	}


	public function getFieldList($result) { 
		$arr = $this->fetchField($result, 'name');

		return $arr;
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) { 
		return mysqli_fetch_field_direct($result, $i)->type;
	}

	public function getFieldTypeList($result) {
		return $this->fetchField($result, 'type');
	}

	function getInsertId() { 
		return mysqli_insert_id($this->getConnection());
	}

	/** 
	 * Ϲ   
	 * 
	 * @param string $sql  query 
	 * @return resource  resource
	 */
	public function query($sql) {
		$this->addSql($sql);

		$this->setResult(mysqli_query($this->getConnection(), $sql));
		return $this->getResult();
	}


	/**
	 * Ŀ ̵ 
	 * 
	 * @param int $count ̵ų ġ,  0 
	 * @return bool
	 */
	public function seek($count) { 
		return mysqli_data_seek ($this->getResult(), $count);
	}


	public function spExecute() { 

	}

	public function prepare($sql) { 
		$this->addSql($sql);

		$this->setStatement(mysqli_prepare($this->getConnection(), $sql));
		return $this->getStatement();
	}

	public function bind() { 
		$arr = func_get_args();

		$arr = array_merge(array($this->getStatement()), $arr);

		return call_user_func_array("mysqli_stmt_bind_param", $arr);
	}

	public function execute() { 
		return mysqli_stmt_execute($this->getStatement());
	}

	/**
	 * ν ޸  
	 * 
	 * @param resource $stmt prepare  resource
	 * @return bool  
	 * @see Mysql_i::prepare()
	 */
	public function freeStatement($stmt) { 
		return mysqli_stmt_close($stmt);
	}

}

?>