<?php
/**
 * Postgres
 *
 * @package php.db
 */

//import("php.db.DBClient");

/**
 * Postgres  Ŭ 
 *
 * @package php.db
 */
class Postgres extends DBClient {

	/** 
	 * 
	 */
	public function __construct($option) {
		parent::__construct($option);
	}

	/**
	 * database  
	 * 
	 * @return resource  resource
	 */
	protected function _connect() {

		$str = sprintf("host=%s port=%s dbname=%s user=%s password=%s", 
				$this->host,
				$this->port,
				$this->db,
				$this->id,
				$this->pass
		);

		return pg_connect($str, constant($this->newlink));
	}

	/**
	 *  row  
	 *
	 * @return int 
	 */
	public function affectedRows() { 
		return pg_affected_rows($this->getResult());
	}

	/**
	 * Ʈ  ()
	 * 
	 * @return bool 
	 * @see Postgres::commit(), Postgres::rollback();
	 */
	public function begin () { 
		return $this->query("BEGIN WORK;");
	}

	/**
	 *  ݱ 
	 */
	public function close() {
		pg_close($this->getConnection());
	}


	/** 
	 * commit ()
	 *
	 * @return bool
	 * @see Postgres::begin(), Postgres::rollback();
	 */
	public function commit() {
		return $this->query("COMMIT;");
	}

	/**
	 *  ޼ 
	 * 
	 * @return string  ޼ 
	 */
	public function error() {
		return pg_last_error($this->getConnection());
	}

	/**
	 * ڿ escape	
	 * 
	 * @param string $str  escape  ڿ 
	 * @return string escape  ڿ
	 */
	public function escape($str) { 
		return pg_escape_string($str);
	}

	/**
	 *  select  ؼ fetch    (row) Ѵ. 
	 *
	 * ϵǴ  array('ʵ' => '', ...); ¸ . 
	 * 
	 * @param resource $result select   resource
	 * @return array row Ÿ 
	 */
	public function fetch($result) {
		return pg_fetch_assoc($result);
	}

	public function fetchAll($result) { 
		return pg_fetch_all($result);
	}

	/** 
	 * ޸  
	 * 
	 * @return bool
	 */
	public function free($result) { 
		return pg_free_result ($result);
	}

	/** 
	 * Ϲ   
	 * 
	 * <code>
	 * $db = DB_('postgres', 'test', true);
	 * 
	 * // 1. ⺻   
	 * $db->query("insert into test_table values ('123', '456')");
	 *
	 * // 2. ε   
	 * $db->query('insert into test_table values ($1, $2)', array('123','456'));
	 * 
	 * $db->close();
	 * </code>
	 * 
	 * @param string $sql  query , ε   $1, $2   · ǥ 
	 * @param array	 $param ε  
	 * @return resource  resource
	 */
	public function query($query, $param = array()) {
		if (sizeof($param) > 0) { 
			$this->setResult(pg_query_params($this->getConnection(), $query, $param));
		} else { 
			$this->setResult(pg_query($this->getConnection(), $query));
		}

		return $this->getResult();
	}

	/**
	 * DBData  
	 *
	 * <code>
	 * 
	 * $db->getData('select * from test_table');
	 *
	 * $db->getData(array('select * from test_table where id = $1', array('aaa')));
	 * 
	 * $db->getData(array('sql' => 'select * from test_table where id = $1', 'param' => array('aaa')));
	 * 
	 * </code>
	 * 
	 * @param	string|array $query DB query
	 * @param	boolean $isOne ε ĭ ű
	 * @return	DBData 
	 */
	public function getData($query, $isOne = false) 
	{
		if (gettype($query) == "array") { 
			$this->query($query['sql'] || $query[0], $query['param'] || $query[1]);
		} else { 
			$this->query($query);	
		}

		$data = $this->createData($this->getResult());

		if (!$this->getResult())  
			$this->free($this->getResult());

		if ($isOne) 
			$data->next();

		return $data;
	}

	/**
	 *    ʵ  Ѵ.
	 *
	 * @param resource $result select   resource
	 * @return int ʵ尳 
	 */
	public function getFieldCount($result) {
		return pg_num_fields ($result);
	}

	/**
	 *  ġ ʵ ̸ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵ̸ 
	 */
	public function getFieldName($result, $i) {
		return pg_field_name($result, $i);
	}

	/**
	 *  ġ ʵ Ÿ ´. 
	 *
	 * @param resource $result select   resource
	 * @param int $i ʵ ġ, ó 0 
	 * @return string ʵŸ
	 */
	public function getFieldType($result, $i) {
		return pg_field_type($result, $i);
	}


	/**
	 * select  ؼ ¡ DBData Ѵ. 
	 *
	 * <code>
	 * 
	 * $db->getPageData('select * from test_table', 1, 10);
	 *
	 * $db->getPageData(array('select * from test_table where id = $1', array('aaa')), 1, 10);
	 * 
	 * $db->getPageData(array('sql' => 'select * from test_table where id = $1', 'param' => array('aaa')), 1, 10);
	 * 
	 * </code>
	 *
	 * @param string|array $query select 
	 * @param int $page    
	 * @param int $count  Ʈ  
	 * @return DBData
	 */
	public function getPageData($query, $page, $count = 10) {

		//  ϱ 
		$start = ($page-1)*$count+1;

		if (gettype($query) == "array") { 
			if ($query['sql'])	$query['sql']	.= " limit $count offset $start";
			if ($query[0])		$query[0]		.= " limit $count offset $start";
		} else { 
			$query .= " limit $count offset $start";
		}

		return $this->getData($query, false);
	}

	/** 
	 * rollback ()
	 *
	 * @return bool 
	 */
	public function rollback() {
		return $this->query("ROLLBACK;");
	}

	/**
	 * Ŀ ̵ 
	 * 
	 * @param int $count ̵ų ġ,  0 
	 * @return bool
	 */
	public function seek($count) { 
		return pg_result_seek($this->getResult(), $count);
	}

	public function spExecute() { 

	}


	/**
	 *  Ľϱ (prepare)
	 * 
	 * <code>
	 *  $db->prepare("test_query", 'select * from test_table where id = $1');
	 * </code>
	 * 
	 * @param string $name prepare  ̸ 
	 * @param string $query prepare , ߿ ε  $1,$2   · ǥõȴ. 
	 * @see Postgres::execute()
	 */
	public function prepare($name, $query) {
		$this->setResult(pg_prepare($this->getConnection(), $name, $query));
		return $this->getResult();
	}


	/**
	 * prepare    
	 *
	 * <code>
	 * $db = DB_('postgres','test', true);
	 *
	 * $db->prepare('test_query', 'select * from test_table where id = $1');
	 * echo $db->execute('test_query', array('test value'));
	 *
	 * $db->close();
	 * </code>
	 *
	 * @param string $name prepare  ̸ 
	 * @param array $data  ε  Ʈ 
	 * @return resource   ҽ 
	 */
	public function execute($name, $data = array()) {
		$this->setResult(pg_execute($this->getConnection(), $name, $data));
		return $this->getResult();
	}

}

?>