<?php
/**
 * php.db Ű Լ  
 * static ޼ҵ忡  
 * 
 * @package php.function
 */

/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = db_('mssql', 'test_db', true); </code>
 *
 * @see DBClient::createConnector()
 * @param string $class  DBClient  Ŭ̸ (mssql, oracle, cubrid, mysql, mysql_i, sqlite, postgres)
 * @param string|array $db db ϸ Ǵ dbȯ 迭 
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Mssql|Oracle|Mysql|Cubrid|Postgres|Mysql_i|Sqlite DBClient  ü
 */
function db_($class, $db, $isConnect = false) { 
	return DBClient::createConnector($class, $db, $isConnect);
}

/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = cubrid_('test_db', true); </code>
 *
 * @see db_()
 * @param string|array $db db ϸ Ǵ dbȯ 迭 
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Cubrid DBClient  ü
 */
function cubrid_($db, $isConnect = false) { 
	return DB_('cubrid', $db, $isConnect);
}

/**
 * Data ü  Լ 
 * 
 * <code>echo dbdata_(null, '̺');</code>
 * 
 * @param $connector IConnector 
 * @param $table string ̸̺
 * @return DBData  DBData ü
 */
function dbdata_($connector = null, $table = null) { 
	return new DBData($connector, $table);
}

/**
 * DBClient ƿƼ ԼԴϴ.
 * 
 * <code>$db = mssql_('test_db', true); </code>
 *
 * @see db_()
 * @param string|array $db db ϸ Ǵ dbȯ 迭 
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @param bool $isRemote ο ũ弭   , ٷ ɷ true, ƴϸ false
 * @return Mssql DBClient  ü
 */
function mssql_($db, $isConnect = false, $isRemote = false) { 
	$db = db_('mssql', $db, $isConnect);

	if ($isRemote) $db->remote();

	return $db;
}

/**
 * mysql ƿƼ ԼԴϴ.
 * 
 * <code>$db = mysql_('test_db', true); </code>
 *
 * @see db_()
 * @param string|array $db db ϸ Ǵ dbȯ 迭 
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Mysql DBClient  ü
 */
function mysql_($db, $isConnect = false) { 

	return db_('mysql', $db, $isConnect);
}

/**
 * mysql_i ƿƼ ԼԴϴ.
 * 
 * <code>$db = mysqli_('test_db', true); </code>
 *
 * @see db_()
 * @param string|array $db db ϸ Ǵ dbȯ 迭 
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Mysql_i DBClient  ü
 */
function mysqli_($db, $isConnect = false) { 
	return db_('mysql_i', $db, $isConnect);
}

/**
 * oracle ƿƼ ԼԴϴ.
 * 
 * <code>$db = oracle_('test_db', true); </code>
 *
 * @see db_()
 * @param string|array $db db ϸ Ǵ dbȯ 迭 
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Oracle DBClient  ü
 */
function oracle_($db, $isConnect = false) { 
	return db_('oracle', $db, $isConnect);
}

/**
 * postgres  ƿƼ ԼԴϴ.
 * 
 * <code>$db = pg_('test_db', true); </code>
 *
 * @see db_()
 * @param string|array $db db ϸ Ǵ dbȯ 迭 
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Postgres DBClient  ü
 */
function postgres_($db, $isConnect = false) { 
	return db_('postgres', $db, $isConnect);
}

/**
 * sqlite  ƿƼ ԼԴϴ.
 * 
 * <code>$db = sqlite_('test_db', true); </code>
 *
 * @see db_()
 * @param string|array $db db ϸ Ǵ dbȯ 迭 
 * @param bool $isConnect ü  ٷ ų , ٷ ɷ true, ƴϸ false
 * @return Sqlite DBClient  ü
 */
function sqlite_($db, $isConnect = false) { 
	return db_('sqlite', $db, $isConnect);
}

?>