<?php
/**
 * php.lang Ű Լ  
 * static ޼ҵ忡  
 * 
 * @package php.function
 */

/**
 *    
 *
 * @return array 
 */
function global_($type) { 
	return Request::getGlobals($type);
}

/**
 * $_GET   ޱ 
 * ʵ忡  ٸ ⺻ $_GET   Ǿ. 
 *
 * @param string $field	get   
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function get_($field, $value = '', $is_set = false) {
	return Request::get($field, $value, $is_set);
}

/**
 * $_POST   ޱ 
 * ʵ忡  ٸ ⺻ $_POST   Ǿ. 
 *
 * @param string $field	post   
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function post_($field, $value = '', $is_set = false) {
	return Request::post($field, $value, $is_set);
}

/**
 * $_REQUEST   ޱ 
 * ʵ忡  ٸ ⺻ $_REQUEST   Ǿ. 
 *
 * @param string $field	get   
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function request_($field, $value = '', $is_set = false) {
	return Request::vars($field, $value, $is_set);
}

/**
 * $_SESSION   ޱ 
 * ʵ忡  ٸ ⺻ $_SESSION   Ǿ. 
 *
 * @param string $field	$_SESSION Ű̸ 
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function session_($field, $value = '') {
	if (empty($_SESSION[$field])) {
		$_SESSION[$field] = $value;
	}
	return $_SESSION[$field];
}

/**
 * $_COOKIE   ޱ 
 * ʵ忡  ٸ ⺻ $_COOKIE   Ǿ. 
 *

 * @param string $field	$_COOKIE   
 * @param mixed $value	$field  ٸ ⺻ '' Ѵ.
 * 
 */
function cookie_($field, $value = '') {
	if (empty($_COOKIE[$field])) {
		$_COOKIE[$field] = $value;
	}
	return $_COOKIE[$field];
}

/**
 * $_SERVER   ޱ 
 *

 * @param string $field	 , ҹ   
 * 
 */
function env_($field) {
	$field = strtoupper($field);

	return $_SERVER[$field];
}

/**
 * 迭 <input type="hidden" > ڿ ȯ
 *

 * @param array $arr		迭
 * @param string $prefix	key  տ  ̸
 * @return string 
 *
 */
function hidden_($arr, $prefix = '') {
	if (gettype($arr) != "array") {
		return "迭 ƴմϴ.";
	}

	$str = "";
	foreach ($arr as $key => $value) {
		$str .= "<input type='hidden' name='".$prefix.$key."' value='".$value."' />\n";
	}

	return $str;
}

/**
 * GET, POST  ؼ hidden ü 
 *

 * @param string $type		get, post, request, session, server  
 * @param string $prefix	key  տ  ̸
 * @return void
 */
function hidden_print($type) {
	echo hidden_(GV_($type));
}

/**
 * GET, POST  ؼ table 
 *

 * @param string $type		get, post, request, session, server  
 * @return void
 */
function view_($type) {

	$arr = GV_($type);

	if (gettype($arr) != "array") {
		return "迭 ƴմϴ.";
	}
	
	echo "<table border='1'>";
	echo  "<tr><th>Key</th><th>Value</th></tr>";
	
	foreach ($arr as $key => $value) {

			if (is_array($value)) { 
				echo  "<tr><td>";
				echo $key;
				echo "</td><td>";
				view_($value);
				echo "</td></tr>";					
			} else { 

				$value = htmlspecialchars($value);
				$value = nl2br($value);
				echo  "<tr><td>";
				echo $key;
				echo "</td><td>";
				echo $value;
				echo "</td></tr>";	
			}
	}

	echo "</table>";
}


/**
 * Data ü  Լ 
 * 
 * <code>echo data_(null, array(....), array(....));</code>
 * 
 * @param $connector IConnector 
 * @param $fields array ʵ帮Ʈ
 * @param $rows array Ÿ迭
 * @return Data  Data ü
 */
function data_($connector = null, $fields = array(), $rows = array()) { 
	return new Data($connector, $fields, $rows);
}

/*
 *   
 *
 * 
 */
function session_close()
{
	session_unset();
	session_destroy();
}

/**
 * ⺻  
 *

 * @param mixed $value	
 * @param mixed $default	⺻ ''
 * @return mixed	$value $default  
 *
 */
function default_($value, $default = '') {

	if (empty($value)) {
		$value = $default;
	}

	return $value;
}

function d_(&$value, $default = '') { 
	if (empty($value)) {
		$value = $default;
	}

	return $value;
}

/**
 * ⺻  
 * 
 * <code>echo IF_($a, '1', '2');   // $a 1̸ $a , ƴϸ 2 </code>
 *

 * @param mixed $value1	
 * @param mixed $value2	
 * @param mixed $default	⺻ ''
 * @return mixed	$value1 $value2   $value1, ٸ $default ȯ
 *
 */
function if_($value1, $value2, $default = '') { 
	return ($value1 == $value2) ? $value1 : $default;
}

/**
 * ⺻  
 * 
 * <code>echo IF2_($a, '1', '2', '3');   // $a 1̸ 2 , ƴϸ 3 </code>
 *

 * @param mixed $value1	
 * @param mixed $value2	
 * @param mixed $return1	$value1 $value2    ȯ  
 * @param mixed $return2	$value1 $value2  ٸ  ȯ  
 * @return mixed	
 *
 */
function if2_($value1, $value2, $return1 = '', $return2 = '') { 
	return ($value1 == $value2) ? $return1 : $return2;
}

/**
 * pre ±׸  print_r() Լ  
 *
 * @param mixed $arr  php   ִ  ڷ
 */
function pre_($arr) {
	echo "<pre>".print_r($arr, true)."</pre>";
}


/**
 * in_array  Ϲ Ű  
 *
 * <code>
 * if (in_list('ƺ', "", "ƺ", 'Ƶ', '')) echo "ƺ ";
 * </code>
 * 
 *  ù°   ߿ ִ Ѵ. 
 *
 * @param mixed|... $arr  php   ִ  ڷ
 * @return bool	迭ȿ   true, ƴϸ false 
 * @see in_array()
 */
function in_list() { 
	$arr = func_get_args();

	$search = array_shift($arr);

	return in_array($search, $arr);
}

/**
 * Tag   Function
 *
 * <code>
 * $div = tag_('div', true)->add('ȳ');   // <div>ȳ</div>
 * </code>
 *
 * @param	string $tag		Tag ̸ 
 * @param	boolean $hasClose	true : Two ±, false : One ±, ⺻ : false 
 * @return  Tag 
 *
 */
function tag_($tag, $hasClose = false) {
	return new Tag($tag, $hasClose);
}

/**
 * html ±׸ ֱ  Լ 
 *
 * <code>
 * $html = html_('a', array('href' => '#'), array('color' => 'red'))->add('ȳ');   // <a href='#' style='color:red'>ȳ</a>
 * </code>
 *
 * @param string $tag html± ̸ 
 * @param array $attribute Ӽ Ʈ 
 * @param array $style Ÿ Ʈ 
 * @return Tag
 */
function html_($tag, $attribute = array(), $style = array()) { 
	$tag = strtolower($tag);

	$obj = new Tag($tag, $GLOBALS['TAG_TABLE'][$tag]);
	$obj->setAttribute($attribute);
	$obj->setStyle($style);

	return $obj;
}

/** 
 * string Ŭ  utility Ŭ 
 *
 * @param $string string ɹڿ
 * @return String 
 */
function string_($string = '') { 
	return new String($string);
}

/**
 * ArrayUtil help Լ
 *
 * @param array $arr	迭
 * @return ArrayUtil
 */
function a_($arr = array()) { 
	return new ArrayUtil($arr);
}

/**
 * html ± ̺ 
 * 
 * @var TAG_TABLE 
 *
 */
$GLOBALS['TAG_TABLE'] = array(
	'a' => true, 
	'acronym' => true, 
	'address' => true, 
	'applet' => true, 
	'area' => true,
	'b' => true,
	'base' => false,
	'basefont' => false,
	'big' => true,
	'blockquote' => true,
	'body' => true,
	'br' => false,
	'button' => true,
	'caption' => true,
	'center' => true,
	'cite' => true,
	'code' => true,
	'col' => false,
	'colgroup' => true,
	'comment' => true,
	'dd' => true,
	'del' => true,
	'dfn' => true,
	'dir' => true,
	'div' => true,
	'dl' => true,
	'dt' => true,
	'em' => true,
	'embed' => true,
	'fieldset' => true,
	'font' => true,
	'form' => true,
	'frame' => false,
	'frameset' => true,
	'head' => true,
	'h1' => true,
	'h2' => true,
	'h3' => true,
	'h4' => true,
	'h5' => true,
	'h6' => true,
	'hr' => true,
	'html' => true,
	'comment' => true,
	'i' => true,
	'iframe' => true,
	'img' => false,
	'input' => false,
	'ins' => true,
	'isindex' => true,
	'kbd' => true,
	'label' => true,
	'legend' => true,
	'li' => true,
	'link' => true,
	'listing' => true,
	'map' => true,
	'marquee' => true,
	'menu' => true,
	'meta' => false,
	'nobr' => true,
	'noframes' => true,
	'noscript' => true,
	'object' => true,
	'ol' => true,
	'option' => true,
	'p' => true,
	'param' => true,
	'plaintext' => true,
	'pre' => true,
	'q' => true,
	'rt' => true,
	'ruby' => true,
	's' => true,
	'samp' => true,
	'script' => true,
	'select' => true,
	'small' => true,
	'span' => true,
	'strike' => true,
	'strong' => true,
	'style' => true,
	'sub' => true,
	'sup' => true,
	'table' => true,
	'tbody' => true,
	'td' => true,
	'textarea' => true,
	'tfoot' => true,
	'th' => true,
	'thead' => true,
	'title' => true,
	'tr' => true,
	'tt' => true,
	'u' => true,
	'ul' => true,
	'var' => true,
	'wbr' => true,
	'xml' => true,
	'xmp' => true,
);
?>