<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * Ű  Ŭ 
 *
 * <code>
 * // 1. accel  
 * new WBAccel(array(
 *     'parent' => $window,
 *     'items' => array(
 *          array('key' => 'F1', 'callback' => 'click_func'),
 *          new WBAccelTemplate(array('key' => 'F2', 'callback' => 'click_func_2'))
 *     )
 * )); 
 * 
 * // 2. Ʈ Ű  
 * new WBPushButton(array(
 *    'parent' => $window,
 *    'caption' => 'accel button', 
 *    'accel' => 'F1',
 * ));
 * 
 * // 3. window  runAccel()  
 * $window->runAccel();
 * </code>
 *
 * @package php.ui.winbinder
 */
class WBAccel extends WBControl { 
	public function __construct($options = array()) { 
		$options['class'] = Accel;

		parent::__construct($options);
	}

	protected function initCreate() { 
		if ($this->items) { 
			$temp = array();

			foreach ($this->items as $item) { 

				if (is_array($item)) { 
					if ($item['id']) { 
						$temp[] = array($item['id'], $item['key']);
					} else { 
						$accelItem = new WBAccelItem(array(
							'key' => $item['key'],
							'callback' => $item['callback'],
						));

						$temp[] = $accelItem->getAccelTemplate();
					} 
				} else if ($item instanceof WBAccelItem) { 
					$temp[] = $item->getAccelTemplate();
				}
			}

			$this->caption = $temp;
		}
	}


}

?>