<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBContainer 
 *
 * @package php.ui.winbinder
 */
class WBContainer extends WBComponent { 
	private $_componentList = array();
	private $_layout = null;
	private $_margin = array();

	public function __construct($options = array()) { 
		parent::__construct($options);
	}

	protected function initEvent() { 
		parent::initEvent();

		// ̺Ʈ  
		$this->setEvent('add', 'onAdd');
		$this->setEvent('remove', 'onRemove');
	}

	/**
	 * WBComponent ߰ 
	 *
	 * @return WBComponent ߰ component 
	 */
	public function add($com) { 

		$com = WBApplication::createObject($com, $this);

		$this->_componentList[] = $com;

		$this->fireEvent('add' , $this, $com);

		// ̾ƿ ٽ ׸ 
		$this->doLayout();

		return $com;
	}

	/**
	 * Ʈ  
	 *
	 */
	public function remove($com) { 
		$tempComponent = $com;

		if (is_string($tempComponent)) { 
			$tempComponent = WBApplication::getObject($tempComponent); 
		}

		$tempList = array();

		foreach ($this->_componentList as $c) { 
			if ($c == $tempComponent) continue;

			$tempList[] = $c;
		}

		$this->fireEvent('remove' , $this, $tempComponent);

		return $tempComponent;
	}

	/**
	 * component Ʈ  
	 *
	 * @return array 
	 */
	public function getComponentList() { 
		return $this->_componentList;
	}

	/**
	 * component   
	 *
	 * @return int 
	 */
	public function length() { 
		return count($this->_componentList);
	}

	/**
	 * Ư Ʈ  
	 *
	 * @param int $i Ʈ ε 
	 * @return WBComponent 
	 */
	public function get($i) { 
		return $this->_componentList[$i];
	}

	/**
	 * layout  
	 *
	 */
	public function setLayout($layout = null) { 
		$this->_layout = $layout;
	}

	/**
	 * layout  
	 *
	 * @return WBLayout 
	 */
	public function getLayout() { 
		return $this->_layout;
	}

	/**
	 * Layout  , ȭ鱸  
	 *
	 */
	public function doLayout() { 
		if ($this->getLayout() != null) {
			// ̾ƿ  
			$this->getLayout()->render($this);
		}
	}

	/**
	 *    ϱ 
	 *
	 * left, right, top, bottom 
	 */
	public function setMargin($direction = 'left', $margin) { 
		$this->_margin[strtolower($direction)] = $margin;
	}

	/**
	 *  
	 *
	 * @return int 
	 */
	public function getMargin($direction) { 
		return $this->_margin[strtolower($direction)];
	}

	/**
	 *  ü  
	 *
	 *
	 */
	public function setMarginAll($margin = array()) { 
		$arr = array('left','right','top','bottom');
		foreach ($arr as $direction) { 
			$this->setMargin($direction, $margin[$direction]);
		}
	}

	/**
	 * ü   
	 *
	 * @return array 
	 */
	public function getMarginAll() { 
		return $this->_margin;
	}


}

?>