<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBData class 
 * 
 * @package php.ui.winbinder
 */
class WBData extends Data { 
	private $_header = array();
	private $_formatter = array();

	public function __construct($options = array()) { 

		if (isset($options['data'])) { 
			parent::__construct();
			$this->setData($options['data']);
		} else { 
			parent::__construct(null, $options['fields'], $options['rows']);
		}

		if (isset($options['header'])) $this->setHeader($options['header']);
		if (isset($options['format'])) $this->setFormatter($options['format']);
	}

	public function setHeader($header) { 
		$this->_header = $header;
	}

	public function setFormatter($formatter) { 
		$this->_formatter = $formatter;
	}

	/**
	 * getRow() method override 
	 * 
	 * <code>
	 * // Data.getRow()
	 * $arr = $data->getRow(0);
	 * print_r($arr);   // array('key' => 'value', 'key' => 'value', ...);
	 *
	 * // WBData.getRow()
	 * $arr = $data->getRow(0);
	 * print_r($arr);   / array('value', 'value', 'value', ....);
	 * </code> 
	 * 
	 * @return array 
	 */
	public function getRow($index, $hasKey = false) { 

		if ($hasKey) { 
			return parent::getRow($index);
		} else { 
			$this->saveIndex();

			$this->setIndex($index);

			$temp = array();

			foreach ($this->getFields() as $field) { 
				$temp[] = $this->get($field);
			}

			$this->returnIndex();

			return $temp;
		}
	}
}

?>