<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBGauge
 *
 * @package php.ui.winbinder
 */
class WBGauge extends WBControl { 
	public function __construct($options = array()) { 
		$options['class'] = Gauge;

		parent::__construct($options);
	}

	// ü ʱȭ 
	protected function initComponent() { 
		parent::initComponent();	

		if (isset($this->text))	$this->setText($this->text);
		if (isset($this->current))	$this->setCurrent($this->current);
		if (isset($this->range))	$this->setRange($this->range);
		if (isset($this->min) || isset($this->max)) $this->setRange(array('min' => intval($this->min), 'max' => intval($this->max)));
		if (isset($this->tooltip))  $this->setToolTip($this->tooltip);
	}

	public function getCurrent() { 
		return $this->getValue();
	}

	public function setCurrent($pos = 0) { 
		$this->setValue($pos);
	}

	public function getRange() { 
		return $this->range;
	}

	public function setRange($range) { 
		if (!isset($this->range)) { 
			$this->range = $range;
		}

		return parent::setRange($range['min'], $range['max']);
	}

	public function setToolTip($tooltip) { 
		$this->setText(array(null, $tooltip));
	}

	public function getPreferedSize() { 
		return array(
			'width' => 100,
			'height' => 20,
		);
	}
}

?>