<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBImage Ŭ 
 *
 * @package php.ui.winbinder
 */
class WBImage extends WBObject { 

	private $_instance;
	private $_path;
	
	/**
	 *  
	 * 
	 * @param array $options ɼ Ʈ 
	 */
	public function __construct($options = array()) { 
		parent::__construct($options);
	}

	/**
	 * Ϸ WBImage ü  
	 * 
	 * @param string $path bmp   
	 */
	public static function loadFile($path) { 

		if (realpath($path)) { 
			$image = new WBImage(array('path' => realpath($path)));
			$image->load();

			return $image;
		} else { 
			return null; 
		}
	}

	/** 
	 *  ̹ instance   
	 *
	 * @return resource 
	 */ 
	public function getInstance() { 
		return $this->_instance;
	}

	/**
	 * ̹ instance  
	 *
	 * 
	 */
	public function setInstance($instance) { 
		$this->_instance = $instance;
	}

	/**
	 * ɼ  width, height  ̹  
	 *
	 * 
	 */
	public function create() { 
		if (isset($this->header)) { 
			$this->setInstance(wb_create_image($this->width, $this->height, $this->header, $this->bits));
		} else { 
			$this->setInstance(wb_create_image($this->width, $this->height));
		}
	}

	/** 
	 * mask image  ,  
	 * 
	 */
	public function createMask() { 
		//$this->setInstance(wb_create_mask());
	}
		
	/**
	 * path ɼ image loading 
	 *
	 * 
	 */
	public function load() { 
		$this->setInstance(wb_load_image($this->path));
	}

	/**
	 * ̹ ޸  
	 *
	 *
	 */
	public function destroy() { 
		wb_destroy_image($this->getInstance());
	}

	/** 
	 * ̹  ϱ 
	 *
	 * @return array ̹ , width, height
	 */
	public function getSize() { 
		$arr = wb_get_size($this->getInstance());

		return array('width' => $arr[0], 'height' => $arr[1]);
	}

	/** 
	 * ̹ Ÿ  
	 *
	 * @param bool $compress  , true ̸ 32bit, false ̸ 24bit 
	 * @return binary ̹ Ÿ 
	 */
	public function getData($compress = true) { 
		return wb_get_image_data($this->getInstance(), $compress);
	}

	/**
	 * ̹ Ÿ Ϸ  
	 *
	 * @param string $filename  ̸, bmp   
	 * @return bool true̸ , false ̸  
	 */
	public function save($filename) { 
		return wb_save_image($this->getInstance(), $filename);
	}

}

?>