<?php
/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBLabel 
 *
 * @package php.ui.winbinder
 */ 
class WBLabel extends WBControl { 
	public function __construct($options = array()) { 
		$options['class'] = Label;

		parent::__construct($options);
	}

	// ü ʱȭ 
	protected function initComponent() { 
		parent::initComponent();

		if (isset($this->align))		$this->setAlign($this->align);
		if (isset($this->valign))		$this->setVAlign($this->valign);
		if (isset($this->border))		$this->setBorder($this->border);
		if (isset($this->ellipsis))		$this->setEllipsis($this->ellipsis);
		if (isset($this->multiline))	$this->setMultiLine($this->multiline);


	}

	public function setAlign($direction = WBC_LEFT) { 
		if (is_string($direction)) { 
			if(in_array('left', 'right', 'center')) { 
				$direction = constant("WBC_".$direction);
			}
		}

		$this->setStyle($direction, true);
	}

	public function setValign($direction = WBC_TOP) { 
		$this->setStyle($direction, true);
	}

	public function setBorder($isBorder = true) { 
		$this->setStyle(WBC_BORDER, $isBorder);
	}

	public function setEllipsis($isEllipsis = true) { 
		$this->setStyle(WBC_ELLIPSIS, $isEllipsis);
	}

	public function setMultiLine($isMultiLine = true) { 
		$this->setStyle(WBC_MULTILINE, $isMultiLine);
	}

	public function getPreferedSize() { 
		$arr = wb_get_size($this->getText());

		return array(
			'width' => $arr[0] + 14,
			'height' => $arr[1] + 10,
		);
	}
}

?>