<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBMenuItem
 *
 * @package php.ui.winbinder
 */
class WBMenuItem extends WBObject { 

	public function __construct($options = array()) { 
		parent::__construct($options);
	}

	public function getMenuTemplate() { 
		return array($this->id, $this->caption, $this->hint, $this->image, $this->accel);
	}

	public function initMenuItem() { 
		if (isset($this->enabled)) { $this->setEnabled($this->enabled); }
	}

	public function initEvent() { 
		parent::initEvent();

		$this->setEvent('click', 'onClick');
	}

	public function fire($eo) { 
		$this->fireEvent('click', $eo);
	}

	public function onClick($eo) { 
		call_user_func_array($this->callback, array($eo));
	}

	/**
	 * Ȱ  
	 *
	 * @return bool 
	 */
	public function isEnabled() { 
		return wb_get_enabled($this->parent->getControl($this->id)) ;
	}

	/**
	 * enabled  
	 *
	 * @param bool $enabled
	 */
	public function setEnabled($enabled = true) { 
		return wb_set_enabled($this->parent->getControl($this->id), $enabled);
	}
}

?>
