<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */


/**
 * WBPanel 
 *
 * @package php.ui.winbinder
 */
class WBPanel extends WBContainer { 

	public function __construct($options = array()) { 
		parent::__construct($options);
	}

	public function initComponent() { 
		parent::initComponent();

		$this->marginLeft	= (isset($this->marginLeft)	?	$this->marginLeft		: 0);
		$this->marginRight	= (isset($this->marginRight)	? $this->marginRight	: 0);
		$this->marginTop	= (isset($this->marginTop)		? $this->marginTop		: 0);
		$this->marginBottom = (isset($this->marginBottom)	? $this->marginBottom	: 0);

		// ⺻   
		$this->setMarginAll(array(
			'left'	=> $this->marginLeft	,	
			'right' => $this->marginRight	,	
			'top'	=> $this->marginTop		,	
			'bottom' => $this->marginBottom ,	
		));

		if(isset($this->layout)) $this->setLayout($this->layout);
		
	}

	public function setPosition($x = 0, $y = 0) { 
		$this->x = $x;
		$this->y = $y;
	}

	public function getPosition($lparam = false) { 
		if ($lparam) { 
			return array(
				'x' => $this->x + $this->getMargin('left'), 
				'y' => $this->y + $this->getMargin('top')
			);
		} else { 
			return array(
				'x' => $this->x, 
				'y' => $this->y
			);
		}
	}

	public function setSize($width = 0, $height = 0) { 
		$this->width = $width;
		$this->height = $height;

		$this->fireEvent('resize');
	}

	public function getSize($lparam = false) { 
		if ($lparam) { 
			return array(
				'width' => $this->width - $this->getMargin('left') - $this->getMargin('right'), 
				'height' => $this->height - $this->getMargin('top') - $this->getMargin('bottom')
			);
		} else { 
			return array('width' => $this->width, 'height' => $this->height);
		}
	}

	public function toString() { 
		$temp = "";

		$temp .= parent::toString();

		foreach ($this->getComponentList() as $com) { 
			$temp .= ">".$com;
		}

		return $temp;
	}

	public function setVisible($isVisible = true) { 
		$comList = $this->getComponentList();

		foreach ($comList as $com) { 
			$com->setVisible($isVisible);
		}
	}
}

?>