<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBPushButton
 *
 * @package php.ui.winbinder
 */ 
class WBPushButton extends WBControl { 
	public function __construct($options = array()) { 
		$options['class'] = PushButton;

		parent::__construct($options);
	}

	public function initComponent() { 
		parent::initComponent();

		if (isset($this->tooltip)) $this->setToolTip($this->tooltip);
	}

	public function setToolTip($tooltip) { 
		$this->setText(array(null, $tooltip));
	}

	public function getPreferedSize() { 
		$arr = wb_get_size($this->getText());

		return array(
			'width' => $arr[0] + 14,
			'height' => $arr[1] + 10,
		);
	}
}

?>