<?php
/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 * WBRadioButton
 *
 * @package php.ui.winbinder
 */ 
class WBRadioButton extends WBControl { 
	public function __construct($options = array()) { 
		$options['class'] = RadioButton;

		parent::__construct($options);
	}

	// ü ʱȭ 
	protected function initComponent() { 
		parent::initComponent();

		if (isset($this->checked)) $this->setChecked($this->checked);

		if (isset($this->tooltip)) $this->setToolTip($this->tooltip);

		if (isset($this->start)) $this->setGroupStart($this->start);
	}

	public function setGroupStart($isGroupStart = true) { 
		$this->setStyle(WBC_GROUP, $isGroupStart);
	}

	public function isChecked() { 
		return $this->getValue();
	}

	public function setChecked($isChecked = true) { 
		$this->setValue($isChecked);
	}

	public function setToolTip($tooltip) { 
		$this->setText(array(null, $tooltip));
	}

	public function getPreferedSize() { 
		$arr = wb_get_size($this->getText());

		return array(
			'width' => $arr[0] + 20,
			'height' => $arr[1] + 10,
		);
	}
}

?>