<?php

/**
 *
 * @package php.ui.winbinder
 */

/**
 * Window System Ŭ 
 * 
 * 1. ɾ  
 * 2. ý(OS)   
 * 3. phpw ũƮ  
 * 
 *  ޼ҵ static ̴. 
 * 
 * @package php.ui.winbinder
 */
class WBSystem extends PObject { 

	/**
	 * Windows or system32 丮  ˻Ѵ. 
	 *
	 * @param string $filename ˻  ̸ 
	 */ 
	public static function findFile($filename) { 
		return wb_fine_file($filename);
	}

	/**
	 * ɾ Ѵ. 
	 *
	 * @param string $command  ɾ 
	 * @param string $param ɾ  μ 
	 */
	public static function exec($command, $param = '') { 
		wb_exec($command, $param);
	}

	/**
	 * cmd ɾ  , ɾ â . 
	 * 
	 * 
	 */ 
	public static function command() { 
		WBSystem::exec("cmd");
	}

	/**
	 * ܺ  ̿Ͽ url Ѵ. 
	 *
	 * @param string $url ̵ url 
	 */
	public static function url($url) { 
		if (str_pos($url, 'http://') == false) { 
			$url  = "http://{$url}";
		}

		WBSystem::exec($url);
	}

	/**
	 *  α׷  
	 *
	 * @param string $mailto  ּ 
	 */
	public static function mail($mailto) { 
		WBSystem::exec("mailto:{$mailto}");
	}

	/**
	 *  ý ɾ  
	 *
	 * @param string $command  ɾ 
	 * @param string $param ɾ μ 
	 */
	public static function run($command, $param = '') { 
		WBSystem::exec(WBSystem::findFile($command), $param);
	}

	/** 
	 * 丮  
	 * 
	 * @param string $dir  丮, ϰ  丮 
	 */
	public static function open($dir = '') { 
		if (is_dir($dir) || $dir == '') { 
			WBSystem::exec($dir);
		}
	}

	/**
	 * phpw ũƮ  
	 * 
	 * @param string $phpw ũƮ  (.phpw)
	 * @param string $param ɾ μ 
	 */ 
	public static function script($phpw, $param = '') { 
		if (strpos(strtolower($phpw), ".phpw") === false) { 
			echo "    Դϴ.", PHP_EOL;
		} else { 
			WBSystem::exec($phpw, $param);
		}
	}

	/**
	 * phpw ũƮ   νϽ ࿩θ üũѴ. 
	 *
	 * @param string $title νϽ    
	 * @param bool $bring  true ̸   νϽ  ´. ⺻ false.
	 */
	public static function isRunInstance($title, $bring = false) { 
		return wb_get_instance($title, $bring);
	}

	/**
	 * ϵ Ʈ   ´. 
	 * 
	 * <code>
	 * // Ű  
	 * "HKCU" or "HKEY_CURRENT_USER"
	 * "HKLM" or "HKEY_LOCAL_MACHINE"
	 * "HKCR" or "HKEY_CLASSES_ROOT"
	 * "HKU" or "HKEY_USERS"
	 * "HKCC" or "HKEY_CURRENT_CONFIG"
	 * "HKD" or "HKEY_DYN_DATA"
	 * </code>
	 *
	 * @param string $key  Ű 
	 * @param string $subkey Ű
	 * @param string $entry Ʈ
	 * @return mixed ϵ Ʈ  
	 * 
	 */
	public static function getRegistry($key, $subkey, $entry = '') { 
		return wb_get_registry_key($key, $subkey, $entry);
	}

	/**
	 * Ʈ  Ѵ. 
	 * 
	 * @param string $key  Ű 
	 * @param string $subkey Ű
	 * @param string $entry Ʈ
	 * @param mixed $value ϵ Ʈ  
	 *
	 */
	public static function setRegistry($key, $subkey, $entry = '', $value = null) { 
		return wb_set_registry_key($key, $subkey, $entry, $value);
	}

	/**
	 * Windows(OS) ý  ´. 
	 * 
	 * <pre> 
	 * - appmemory (string)
	 *   The total memory used by the application
	 * 
	 * - commandline (string) 
	 *   The original Windows command line including the executable file
	 * 
	 * - computername (string) 
	 *   The name of the computer inside the network
	 * 
	 * - consolemode (integer)
	 *   1 indicates that console mode (DOS box) is active, 0 otherwise
	 * 
	 * - diskdrives (string) 
	 *   The list of all available disk drives
	 * 
	 * - exepath (string)
	 *   The path to the main executable (PHP.EXE)
	 * 
	 * - extensionpath (string) 
	 *   The path to the current PHP extension
	 * 
	 * - fontpath (string) 
	 *   The current font path
	 * 
	 * - freememory (integer)
	 *   The available physical memory
	 * 
	 * - gdiobjects (integer)
	 *   The number of currently allocated GDI handles
	 * 
	 * - instance (instance)
	 *   The instance identifier of the current application
	 * 
	 * - ospath (string)
	 *   The current OS path
	 * 
	 * - osversion (string) 
	 *   The complete OS version name
	 * 
	 * - osnumber (string) 
	 *   The numeric OS version number
	 * 
	 * - pgmpath (string)  
	 *   The default OS application path
	 * 
	 * - screenarea (string) 
	 *   The total area (x, y, width, height) of the screen, in pixels
	 *   ex) 0 0 1280 960
	 * 
	 * - systemfont (string)
	 *   The common (default) system font for dialog boxes
	 *   ex) Tahoma 8 Regular
	 * 
	 * - systempath (string)
	 *   The OS system path
	 * 
	 * - temppath (string) 
	 *   The path used by the OS to hold temporary files
	 * 
	 * - totalmemory (string) 
	 *   The total physical memory installed
	 * 
	 * - username (string) 
	 *   The name of the currently logged user
	 * 
	 * - userobjects (integer)
	 *   The number of currently allocated USER handles
	 * 
	 * - workarea (string) 
	 *   The valid area (x, y, width, height) of the screen, in pixels
	 *   ex) 0 0 1280 926
	 * </pre>
	 *
	 * @param string $info ý  Ű 
	 */ 
	public static function info($info) { 
		return wb_get_system_info($info);
	}

	/**
	 * Ʈ   ´. 
	 * 迭· ؼ  ´. 
	 *
	 * 
	 * @return array font,size,type   迭 
	 */ 
	public static function getFontInfo() { 
		$temp = explode(" ", WBSystem::info("systemfont"));

		return array(
			'font' => $temp[0],
			'size' => $temp[1],
			'type' => $temp[2],
		);
	}

	/**
	 * ȭ ü ػ󵵸 Ѵ.
	 *
	 * @return array x,y,width,height  迭 
	 */
	public static function getScreen() { 
		$temp = explode(" ", WBSystem::info("screenarea"));

		return array(
			'x'		=> $temp[0],
			'y'		=> $temp[1],
			'width'	=> $temp[2],
			'height' => $temp[3],
		);
	}

	/**
	 * ̿밡 ȭ ػ󵵸 Ѵ. 
	 * ٸ  ũ⸦ Ѵ. 
	 *
	 * @return array x,y,width,height  迭 
	 */
	public static function getAvailableScreen() { 
		$temp = explode(" ", WBSystem::info("workarea"));
		$temp = array_map('intval', $temp);

		return array(
			'x'		=> $temp[0],
			'y'		=> $temp[1],
			'width'	=> $temp[2],
			'height' => $temp[3],
		);
	}

	/**
	 * ý 带 Ѵ. 
	 * 
	 * <pre>
	 * WBC_OK : Default system sound
	 * WBC_INFO : System information sound
	 * WBC_WARNING : Warning sound
	 * WBC_STOP : Error sound
	 * WBC_QUESTION : Question sound
	 * WBC_BEEP : 
	 * </pre>
	 * 
	 * @param int|string $style  
	 */
	public static function play($style) { 
		if (is_string($style)) { 
			$style = constant("WBC_".strtoupper($style));
		}

		wb_play_sound($style);
	}

	/**
	 * Ű峪 콺 ̺Ʈ Ͼ  ð  Ų. 
	 *
	 * <code>
	 * // Ű Է     
	 * if (WBSystem::wait() == 27) {
	 *    echo "esc key pressed ";
	 * }
	 *
	 * // 5 Ǵ keyboard Ű   
	 * WBSystem::wait($window, 5000, WBC_KEYDOWN)
	 * </code>
	 *
	 * @param handle $window winbinder  ڵ 
	 * @param int $pause  ð , 1000 1 , ex) 5000 = 5 
	 * @param int $flags  WBC_MOUSEDOWN, WBC_MOUSEUP, WBC_KEYDOWN, WBC_KEYUP
	 * @param int key code 
	 */
	public static function wait($window  = 0 , $pause = 0 , $flags = 0 ) { 
		return wb_wait($window, $pause, $flags);
	}
}
?>