<?php

/**
 * winbinder Ű 
 * 
 * 
 * @package php.ui.winbinder
 */

/**
 *   ⺻ Ŭ 
 *
 * @package php.ui.winbinder
 */ 
class WBWindow extends WBContainer { 

	private $_accelList = array();

	private $_rootPanel = null;

	private $_statusBar = null;
	private $_toolBar = null;
	private $_menu = null;

	public function __construct($options = array()) { 
		parent::__construct($options);
	}

	protected function initCreate() { 
		parent::initCreate(); 

		$defaultStyle = WBC_INVISIBLE | WBC_NOTIFY | WBC_CUSTOMDRAW;
		$defaultParam = WBC_DBLCLICK | WBC_MOUSEMOVE | WBC_MOUSEDOWN | WBC_MOUSEUP | WBC_KEYDOWN | WBC_KEYUP | WBC_GETFOCUS | WBC_REDRAW | WBC_RESIZE | WBC_HEADERSEL ;

		$this->style |= $defaultStyle;
		$this->param |= $defaultParam;
	}

	protected function initEvent() { 
		parent::initEvent(); 

		// ̺Ʈ  
		$this->setEvent('show',			'onShow');
		$this->setEvent('hide',			'onHide');
		$this->setEvent('close',		'onClose');
		$this->setEvent('mousedown',	'onMouseDown');
		$this->setEvent('mousemove',	'onMouseMove');
		$this->setEvent('mouseup',		'onMouseUp');
		$this->setEvent('focus',		'onFocus');
		$this->setEvent('dblclick',		'onDoubleClick');
		$this->setEvent('active',		'onActive');
		$this->setEvent('accel',		'onAccel');
	}

	protected function initComponent() { 
		parent::initComponent();

		// ̺Ʈ ڵ鷯  
		$this->setHandler();

		// RootPanel  
		$this->setRootPanel(new WBPanel(array('parent' => $this)));

		// Ű    
		if (isset($this->layout)) $this->setLayout($this->layout);

		// Ű    
		if (isset($this->accel)) $this->setAccel($this->accel[0], $this->accel[1]);

		// menu, toolbar, statusbar  
		if (isset($this->menu)) $this->setMenu($this->menu);
		if (isset($this->toolbar)) $this->setToolBar($this->toolbar);
		if (isset($this->statusbar)) $this->setStatusBar($this->statusbar);

	}

	public function handler($window, $id, $ctrl = 0, $param1 = 0, $param2 = 0, $param3 = 0) { 

		// ̺Ʈü (EventObject  ʿ)
		$eventObject = new WBEvent($window, $id, $ctrl, $param1, $param2, $param3);

		switch($id) { 
		case IDCLOSE:			// ݱ ư 
		case IDDEFAULT:			 
			//   ̺Ʈ
			$this->fire($eventObject);
			break;
		default: 
			// component ̺Ʈ 
			$obj = WBApplication::getObject($id);
			
			if ($obj) { 
				$obj->fire($eventObject);
			} 
			//else { 
			//	$this->fireEvent('accel', $eventObject);
			//}

			break;

		}
			
	}

	public function setHandler() { 
		wb_set_handler($this->getInstance(), '__window_handler');
	}

	protected function createComponent() { 
		$instance = wb_create_window(WBApplication::getInstance($this->parent), $this->class, $this->title, $this->x, $this->y, $this->width, $this->height, $this->style, $this->param);

		WBApplication::setWindow($instance, $this);

		return $instance;
	}
	
	public function close() { 
		
		wb_destroy_window($this->getInstance());

		// ̺Ʈ  
		$this->fireEvent('close');
	}

	public function getChild() { 
		return $this->getItemList();
	}

	public function setMaximized() { 
		$this->setSize(WBC_MAXIMIZED, null);
	}

	public function setMinimized() { 
		$this->setSize(WBC_MINIMIZED, null);
	}

	public function setNormal() { 
		$this->setSize(WBC_NORMAL, null);
	}

	public function isMinimized() { 
		return ($this->getSize() == WBC_MINIMIZED);
	}

	public function isMaximized() { 
		return ($this->getSize() == WBC_MAXIMIZED);
	}

	public function isNormal() { 
		return ($this->getSize() == WBC_NORMAL);
	}

	public function setIcon($source) { 
		return $this->setImage($this->getInstance(), $source);
	}

	public function getTitle() { 
		return $this->getText();
	}

	public function setTitle($str) { 
		$this->setText($str);
	}

	public function wait($pause = null, $flags = null) { 
		return wb_wait($this->getInstance(), $pause, $flags);
	}

	public function setAccel($id, $key, $callback = '') { 
		$this->_accelList[$id] = array('id' => $id, 'key' => $key, 'callback' => $callback);
	}

	public function runAccel() { 
		new WBAccel(array(
			'parent' => $this->getInstance(), 
			'items' => $this->_accelList
		));
	}

	public function setMinimumSize($width = 0, $height = 0) {
		parent::setMinimumSize($width, $height);

		$this->setArea(WBC_MINSIZE, 0, 0, $width, $height);
	}

	public function setMaximumSize($width = 0, $height = 0) {
		parent::setMaximumSize($width, $height);

		$this->setArea(WBC_MAXSIZE, 0, 0, $width, $height);
	}

	public function setTaskBar($isTaskBar = true) { 
		$this->setStyle(WBC_TASKBAR, $isTaskBar);
	}

	public function setRootPanel($panel) { 
		$this->_rootPanel = $panel; 
	}

	public function getRootPanel() { 
		return $this->_rootPanel;
	}

	public function setStatusBar($statusBar) { 
		$this->_statusBar = $statusBar;

		return $this->_statusBar;
	}

	public function getStatusBar() { 
		return $this->_statusBar;
	}

	public function createToolBar($options = array()) { 
		$options['parent'] = $this;

		return new WBToolBar($options);
	}

	public function createMenu($items) { 
		$this->_menu = new WBMenu(array(
			'parent' => $this,
			'items'	 => $items,
		));

		return $this->_menu;
	}

	public function getMenu() { 
		return $this->_menu;
	}

	public function doLayout() { 

		if ($this->_rootPanel instanceof WBPanel) { 

			//  ũ  
			$size	= $this->getSize(true);

			$this->_rootPanel->setBounds(0, 0, $size['width'], $size['height'] );
		}
	}

	public function fire($eo) { 
		if ($eo->isResize())	{ $this->fireEvent('resize', $eo);  return ; } 
		if ($eo->isMouseDown()) { $this->fireEvent('mousedown', $eo); return ; } 
		if ($eo->isMouseMove()) { $this->fireEvent('mousemove', $eo); return ; } 
		if ($eo->isMouseUp())	{ $this->fireEvent('mouseup', $eo); return ; } 
		if ($eo->isRedraw())	{ $this->fireEvent('redraw', $eo); return ; } 
		if ($eo->isFocus())		{ $this->fireEvent('focus', $eo); return ; } 
		if ($eo->isIDClose())	{ $this->close(); return; }
	}

	public function add($component) { 
		if ($this->_rootPanel instanceof WBPanel) { 
			$com = WBApplication::createObject($component, $this);

			return $this->_rootPanel->add($com);
		}

		return $component;
	}

	public function setLayout($layout) { 
		if ($this->_rootPanel instanceof WBPanel) { 
			$this->_rootPanel->setLayout($layout);
		}
	}

	/**
     * ⺻ 1  
	 *
	 */
	public function createTimer($callback, $interval = 1000) { 
		return new WBTimer(array(
			'parent'	=> $this,
			'interval'	=> $interval,
			'event'		=> array(
				'click' => $callback
			),
		));
	}

	public function destroyTimer($timer) { 
		return $timer->destroyTimer();
	}

}


function __window_handler($window, $id, $ctrl = 0, $param1 = 0, $param2 = 0, $param3 = 0) { 
	WBApplication::getWindow($window)->handler($window, $id, $ctrl, $param1, $param2, $param3);
}

?>