<?php

/**
 * Winbinder Tree 
 * 
 * @package php.ui.winbinder.tree
 */


/**
 * WBTreeNode
 * 
 * @package php.ui.winbinder.tree
 */

class WBTreeNode extends WBObject { 
	public function __contruct($options = array()) { 
		parent::__contruct($options);
	}

	public function createChild($opt = array()) { 

		$opt['type'] = 2;
		$opt['where'] = $this->getInstance();

		return $this->tree->createNode($opt);
	}

	public function createSibling($opt = array()) { 
		$opt['type'] = 1;
		$opt['where'] = $this->getInstance();

		return $this->tree->createNode($opt);
	}

	public function isLeaf() { 
		return ($this->tree->getItemCount() > 0) ? false : true;
	}

	public function isRoot() { 
		return ($this->getLevel() == 1);
	}

	public function getLevel() { 
		return $this->tree->getLevel($this->getInstance());
	}

	public function getParent() { 
		return new WBTreeNode(array(
			'tree' => $this->tree, 
			'instance' => $this->tree->getParent($this->getInstance())
		));
	}

	public function getInstance() { 
		return $this->instance;
	}

	public function setInstance($instance) { 
		$this->instance = $instance;
	}

	public function getText() { 
		return $this->tree->getText($this->getInstance());
	}

	public function setText($text) { 
		return $this->tree->setText($text, $this->getInstance());
	}

	public function isExpanded() { 
		return ( $this->tree->getState($this->getInstance()) == 1 );
	}

	public function expand() { 
		$this->tree->setState($this->getInstance(), true);
	}

	public function collapse() { 
		$this->tree->setState($this->getInstance(), false);
	}

	/**
	 * node  selected Ǿ parent  ڵ expand ȴ. 
	 *
	 */
	public function select($isSelect = true) { 
		$this->tree->setSelected($this->getInstance(), $isSelect);
	}

	public function delete() { 
		return $this->tree->deleteItems($this->getInstance());
	}

	public function getSelectedValue() { 
		return $this->tree->getValue();
	}

	public function setImage($imageindex) { 
		return $this->tree->setItemImage($imageindex, $this->getInstance());
	}

}

?>